/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.entity.common;

import cn.easyutil.easyapi.util.StringUtil;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Random;

public enum CustomRemarkEnum {
    userName(1, "${char(name)}", "\u7528\u6237\u6635\u79f0"),
    titleName(1, "${char(text)}", "\u4e2d\u6587\u5185\u5bb9"),
    hName(1, "${char(ho)}", "\u516c\u53f8\u540d\u79f0"),
    addressName(1, "${char(address)}", "\u5730\u5740"),
    mobile(1, "${char(mobile)}", "\u624b\u673a\u53f7\u7801"),
    md5(1, "${char(md5)}", "\u968f\u673a\u4e00\u4e2amd5\u4e32"),
    aes(1, "${char(aes)}", "\u968f\u673a\u4e00\u4e2aaes\u4e32"),
    randomStr(1, "${char(", "\u968f\u673achar"),
    rStr(1, "${char}", "\u9ed8\u8ba44\u4e2a\u968f\u673a\u6570\u5b57+\u5b57\u6bcd"),
    randomInt(2, "${int(", "\u968f\u673aint"),
    rint(2, "${int}", "\u968f\u673a\u9ed8\u8ba4int"),
    randomDouble(3, "${double(", "\u968f\u673aint"),
    rdouble(3, "${double}", "\u968f\u673a\u9ed8\u8ba4int"),
    randomTime(5, "${time(", "\u65f6\u95f4\u8f6c\u6362\u5b57\u7b26\u4e32"),
    rTime(5, "${time}", "\u5f53\u524d\u65f6\u95f4\u6233"),
    randomUrl(6, "${url(", "\u968f\u673a\u7f51\u7edc\u5730\u5740"),
    rUrl(6, "${url}", "\u968f\u673a\u56fe\u7247\u5730\u5740"),
    unknow(999, "null", "\u672a\u77e5");

    private Integer type;
    private String rule;
    private String remark;
    private static final String[] unames;
    private static final String[] hnames;
    private static final String[] tnames;
    private static final String[] anames;
    private static final String[] purl;
    private static final String[] vurl;

    private CustomRemarkEnum(Integer type, String rule, String remark) {
        this.type = type;
        this.rule = rule;
        this.remark = remark;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getRule() {
        return this.rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public static Integer getRule(String rule) {
        if (StringUtil.isEmpty(rule)) {
            return unknow.getType();
        }
        CustomRemarkEnum[] values = CustomRemarkEnum.values();
        rule = rule.trim().toLowerCase();
        for (CustomRemarkEnum custom : values) {
            if (!rule.startsWith(custom.getRule())) continue;
            return custom.getType();
        }
        return unknow.getType();
    }

    public static String getExample(String rule) {
        if (StringUtil.isEmpty(rule)) {
            return "";
        }
        Integer rule2 = CustomRemarkEnum.getRule(rule);
        if (rule2.equals(unknow.getType())) {
            return rule;
        }
        if (!rule.endsWith("}")) {
            return rule;
        }
        String ruleStr = rule.substring(rule.indexOf("${") + 2, rule.length() - 1).toLowerCase();
        switch (rule2) {
            case 1: {
                if (ruleStr.equals("char")) {
                    return StringUtil.getRandomString(4);
                }
                if (ruleStr.equals("char(name)")) {
                    return unames[new Random().nextInt(unames.length - 1)];
                }
                if (ruleStr.equals("char(ho)")) {
                    return hnames[new Random().nextInt(hnames.length - 1)];
                }
                if (ruleStr.equals("char(address)")) {
                    return anames[new Random().nextInt(anames.length - 1)];
                }
                if (ruleStr.equals("char(text)")) {
                    return tnames[new Random().nextInt(tnames.length - 1)];
                }
                if (ruleStr.equals("char(mobile)")) {
                    return "188" + StringUtil.getRandomString(8, "0123456789");
                }
                if (ruleStr.equals("char(md5)")) {
                    return StringUtil.toMD5("123456");
                }
                if (!ruleStr.equals("char(aes)")) break;
                return StringUtil.getRandomString(16);
            }
            case 2: {
                if (ruleStr.equals("int")) {
                    return new Random().nextInt(2) + "";
                }
                if (!ruleStr.startsWith("int(") && !ruleStr.endsWith(")")) break;
                String intStr = ruleStr.substring(ruleStr.indexOf("int(") + 4, ruleStr.length() - 1);
                if (!intStr.contains(",")) {
                    try {
                        return new Random().nextInt(Integer.valueOf(intStr)) + "";
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                String[] split = intStr.split(",");
                if (split.length <= 1) {
                    try {
                        return new Random().nextInt(Integer.valueOf(split[0])) + "";
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                try {
                    int val;
                    int s1 = Integer.valueOf(split[0]);
                    int s2 = Integer.valueOf(split[1]);
                    if (s1 < 0 || s2 < 0) {
                        return "-1";
                    }
                    if (s1 == s2) {
                        return split[0];
                    }
                    if (s1 > s2) {
                        int val2;
                        while ((val2 = new Random().nextInt(s1)) < s2) {
                        }
                        return val2 + "";
                    }
                    while ((val = new Random().nextInt(s2)) < s1) {
                    }
                    return val + "";
                }
                catch (Exception e) {
                    break;
                }
            }
            case 3: {
                if (ruleStr.equals("double")) {
                    return "0.25";
                }
                if (!ruleStr.startsWith("double(") && !ruleStr.endsWith(")")) break;
                String doubleStr = ruleStr.substring(ruleStr.indexOf("double(") + 7, ruleStr.length() - 1);
                DecimalFormat df = new DecimalFormat("#.00");
                if (!doubleStr.contains(",")) {
                    try {
                        int intValue = Double.valueOf(doubleStr).intValue();
                        return new Random().nextInt(intValue) + "" + df.format(new Random().nextDouble());
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                String[] split = doubleStr.split(",");
                if (split.length <= 1) {
                    try {
                        int intValue = Double.valueOf(doubleStr).intValue();
                        return new Random().nextInt(intValue) + "" + df.format(new Random().nextDouble());
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                try {
                    int val;
                    int s1 = Double.valueOf(split[0]).intValue();
                    int s2 = Double.valueOf(split[1]).intValue();
                    if (s1 < 0 || s2 < 0) {
                        return "-1" + df.format(new Random().nextDouble());
                    }
                    if (s1 == s2) {
                        return s1 + df.format(new Random().nextDouble());
                    }
                    if (s1 > s2) {
                        int val3;
                        while ((val3 = new Random().nextInt(s1)) < s2) {
                        }
                        return val3 + "" + df.format(new Random().nextDouble());
                    }
                    while ((val = new Random().nextInt(s2)) < s1) {
                    }
                    return val + "" + df.format(new Random().nextDouble());
                }
                catch (Exception e) {
                    break;
                }
            }
            case 4: {
                if (ruleStr.equals("char")) {
                    return StringUtil.getRandomString(4);
                }
                if (!ruleStr.startsWith("char(") && !ruleStr.endsWith(")")) break;
                String charStr = ruleStr.substring(ruleStr.indexOf("char(") + 5, ruleStr.length() - 1);
                try {
                    Integer val = Integer.valueOf(charStr);
                    return StringUtil.getRandomString(val);
                }
                catch (Exception e) {
                    break;
                }
            }
            case 5: {
                if (ruleStr.equals("time")) {
                    return System.currentTimeMillis() + "";
                }
                if (ruleStr.equals("time()")) {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(System.currentTimeMillis());
                }
                if (!ruleStr.startsWith("time(") && !ruleStr.endsWith(")")) break;
                String timeStr = ruleStr.substring(ruleStr.indexOf("time(") + 5, ruleStr.length() - 1);
                try {
                    SimpleDateFormat format = new SimpleDateFormat(timeStr);
                    return format.format(System.currentTimeMillis());
                }
                catch (Exception e) {
                    break;
                }
            }
            case 6: {
                if (ruleStr.equals("url")) {
                    return purl[new Random().nextInt(purl.length - 1)];
                }
                if (!ruleStr.startsWith("url(") && !ruleStr.endsWith(")")) break;
                String urlStr = ruleStr.substring(ruleStr.indexOf("url(") + 4, ruleStr.length() - 1);
                if (urlStr.equals("pic")) {
                    return purl[new Random().nextInt(purl.length - 1)];
                }
                if (!urlStr.equals("vod")) break;
                return vurl[new Random().nextInt(vurl.length - 1)];
            }
            default: {
                return rule;
            }
        }
        return rule;
    }

    static {
        unames = new String[]{"\u77f3\u69b4", "\u534e\u5b89", "\u5982\u82b1", "\u4f2f\u864e", "\u65fa\u8d22", "\u83b2\u82b1", "\u516b\u4e24\u91d1"};
        hnames = new String[]{"\u676d\u5dde\u9a7f\u98de\u79d1\u6280\u6709\u9650\u516c\u53f8", "\u6d59\u6c5f\u963f\u91cc\u5df4\u5df4\u96c6\u56e2", "\u6df1\u5733\u817e\u8baf\u96c6\u56e2", "\u4e07\u8fbe\u4f01\u4e1a", "\u5f00\u5fc3\u9ebb\u82b1\u5f71\u89c6", "\u676d\u5dde\u5609\u5e74\u534e\u623f\u5730\u4ea7", "\u7f8e\u56fd\u82f9\u679c\u96c6\u56e2"};
        tnames = new String[]{"\u6d41\u884c\u8774\u8776\u5251", "LOL\u4e4b\u63d0\u83ab\u961f\u957f", "\u738b\u8005\u8363\u8000\u5143\u54e5\u6559\u5b66", "java-\u4ece\u5165\u95e8\u5230\u5220\u5e93", "\u97ed\u83dc\u9e21\u86cb\u6709\u5927\u7528\u5904", "\u76d8\u70b9\u4f60\u4e0d\u77e5\u9053\u7684\u9648\u8001\u5e08", "\u9504\u79be\u65e5\u5f53\u5348\uff0c\u6c57\u6ef4\u79be\u4e0b\u571f"};
        anames = new String[]{"\u6d59\u6c5f\u676d\u5dde", "\u82cf\u5dde", "\u7f8e\u56fd\u52a0\u5229\u798f\u5c3c\u4e9a\u5dde", "\u521b\u4f1f\u79d1\u6280\u56ed", "\u6c5f\u82cf", "\u897f\u5b89", "\u6ee8\u6c5f\u533a"};
        purl = new String[]{"https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/2721a0fb957b4949a2c4ef3505e70d97.jpg", "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/eaf80ccb4e754f6fada1af42ea737248.jpg", "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/778b813fc28048f6848ec7aadc691a13.jpg", "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/3ac939b7dc9e422abf4fa981edfb8ca5.jpg", "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/104e6044c738429f8679e5bb88e665e4.jpg", "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/39addca3d1794be69b57d8ec86dd622b.jpg", "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/b6f009df8ff7452e9ae9a96d7312f573.jpg"};
        vurl = new String[]{"https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/c74c5c50a7d04d559584867810afd327.mp4", "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/3316bf5183bc414982731088f9daf550.mp4", "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/184355b287144a54b9c0e9bf265f5b08.mp4", "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/1566619e084f4e4b863ca22ffb072c3d.mp4", "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/6fbea57381e14afcb5c3aafc85ed7eda.mp4", "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/8688586e408f44499c3b7bb30b641579.mp4", "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/c969b347bd634e97b7a262a446a3f09f.mp4"};
    }
}

