package cn.easyutil.easyapi.javadoc.util;

import org.springframework.core.DefaultParameterNameDiscoverer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CommentTypeUtil {

    public static Class<?> getMethodReturnClass(String methodName,Class<?> clazz){
        for (Class<?> c=clazz; c!=null&&!c.equals(Object.class); c=c.getSuperclass()) {
            Method[] methods = c.getDeclaredMethods();
            for (Method method : methods) {
                if(method.getName().equals(methodName)){
                    return method.getReturnType();
                }
            }
        }
        return null;
    }

    public static Object getFieldDefaultValue(Class<?> clazz,String fieldName){
        try {
            //尝试获取全局变量
            Field field = clazz.getDeclaredField(fieldName);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & ~Modifier.FINAL);
            field.setAccessible(true);
            Object val = field.get(clazz.newInstance());
            field.setAccessible(false);
            modifiersField.setAccessible(false);
            return val;
        } catch (Exception ignored) {
            return null;
        }
    }

    public static String getMapKeyName(String quoteName,Class<?> clazz,List<String> sourceLines,List<String> imports){
        /*
         * 先处理key，支持两种方式
         * 1. map.put("key",val)
         * 2. map.put(Const.key,val)
         */
        String key = null;
        if(quoteName.contains("\"")){
            key = quoteName.replace("\"","");
        }else{
            List<String> nexts = new ArrayList<>(Arrays.asList(quoteName.split("\\.")));
            //这个就是静态类名了
            String className = nexts.get(0);
            if(nexts.size() == 1){
                //认为这是一个引用变量，引用变量两种情况，全局变量和局部变量
                Object fieldDefaultValue = CommentTypeUtil.getFieldDefaultValue(clazz, className);
                if(fieldDefaultValue == null){
                    //再尝试下局部变量
                    String s = sourceLines.stream().filter(str -> CommentStringUtil.isAssignLine(className, str)).findFirst().orElse(null);
                    if(s == null){
                        return null;
                    }
                    key = s.split("=")[1].replace("\"","").replace(";","").trim();
                }else{
                    key = fieldDefaultValue.toString();
                }
            }else{
                Class<?> aClass = findSimpleNameClass(className, clazz, sourceLines, imports);
                if(aClass == null){
                    //类都加载不到，就不去加载方法了
                    return null;
                }
                nexts.remove(0);
                for (String next : nexts) {
                    Object fieldDefaultValue = CommentTypeUtil.getFieldDefaultValue(aClass, next);
                    if(fieldDefaultValue == null){
                        return null;
                    }
                    key = fieldDefaultValue.toString();
                }
            }
        }
        if(key != null){
            key = key.replace("(","")
                    .replace(")","")
                    .replace(";","")
                    .replace(",","")
                    .replace(".","")
                    .trim();
        }
        return key;
    }

    /**
     * 根据引用名称获取引用的真实类型
     */
    public static Class<?> findSimpleNameClass(String className,Class<?> clazz,List<String> sourceLines,List<String> imports){
        for (String sourceLine : sourceLines) {
            if(!CommentStringUtil.isVariableLine(className,sourceLine)){
                continue;
            }
            if(!sourceLine.contains(";")){
                continue;
            }
            String pre = null;
            if(sourceLine.contains("=")){
                pre = sourceLine.substring(0,sourceLine.indexOf("=")).replace("final","").trim();
            }else{
                pre = sourceLine.replace(";","").replace("final","").trim();
            }
            if(!CommentStringUtil.isVariableLine(className,pre)){
                continue;
            }
            if(pre.contains("<") && pre.contains(">")){
                //去除泛型
                String s = pre.substring(0,pre.indexOf("<"));
                String e = pre.substring(pre.lastIndexOf(">")+1);
                pre = s+e;
            }
            if(pre.split(" ").length!=2 || !pre.split(" ")[1].equals(className)){
                continue;
            }
            className = pre.split(" ")[0];
        }
        String packageName = null;
        String importName = null;
        //试试是不是本包下的类
        for (String anImport : imports) {
            String str = anImport.trim().replace(";","");
            if(str.startsWith("package")){
                packageName = str.substring(str.indexOf("package")+7).trim();
            }
            if(anImport.trim().startsWith("import") && anImport.replace(";","").trim().endsWith(className)){
                importName = anImport.replace("import","").replace(";","").trim();
                break;
            }
        }
        if(importName != null){
            try {
                return Class.forName(importName);
            } catch (ClassNotFoundException ignored) {}
        }
        if(packageName != null){
            try {
                return Class.forName(packageName+"."+className);
            } catch (ClassNotFoundException ignored) {}
        }
        //都找不到再从类属性中找一下
        try {
            return clazz.getDeclaredField(className).getType();
        } catch (Exception ignored) {}

        //是不是java的基础类型
        Class<?> type = BaseClassEnum.getType(className);
        if(type != null){
            return type;
        }
        if(className.equals("true") || className.equals("false")){
            return Boolean.class;
        }
        try {
            Double.valueOf(className);
            return Double.class;
        } catch (NumberFormatException e) {
            return null;
        }
    }

    public static Class<?> findVariableClassByReflection(String variableName,Class<?> clazz,Method method){
        /*
         * 1. private A a;
         * 2. A a = new A;
         * 3. public A test(A a);
         */
        try {
            return clazz.getDeclaredField(variableName).getType();
        } catch (NoSuchFieldException ignored) {}

        DefaultParameterNameDiscoverer discover = new DefaultParameterNameDiscoverer();
        // 实际方法参数形参名称
        String[] parameterNames = discover.getParameterNames(method);
        if(parameterNames == null){
            return null;
        }
        for (int i = 0; i < parameterNames.length; i++) {
            if(parameterNames[i].equals(variableName)){
                return method.getParameters()[i].getType();
            }
        }
        return null;
    }

    public Class<?> findVariableClassByComment(String variableName, List<String> sourceLines,List<String> importLines){

        return null;
    }

    public static Class<?> findQuoteClass(String quoteName, List<String> sourceLines,List<String> importLines,Class<?> clazz){
        String[] split = quoteName.split("\\.");
        /**
         * 第一个数据有五种情况
         * 1. 静态类
         * 2. 引用对象
         * 3. 类内方法
         * 4. new关键字
         * 5. 类内常量
         */
        String quote = split[0];
        Class<?> quoteClass = null;
        if(quote.contains("new")){
            String newStr = quote.replace("new","").trim();
            quote = newStr.substring(0,newStr.indexOf("("));
        }
        if(!quote.contains("(") && !quote.contains(")")){
            //如果没有括号，说明是对象或静态类
            //先假定第一个数据是引用对象
            quoteClass = findSimpleNameClass(quote,clazz,sourceLines,importLines);
            if(split.length==1){
                //如果分隔的字符串长度为1，说明是引用对象，直接返回类型就可以了
                if(quoteClass == null) quoteClass = String.class;
                return quoteClass;
            }
            //走到这一步说明是静态类
            if(quoteClass == null){
                return null;
            }
        }else{
            //这里是本地方法引用，先获取到类型再说
            String methodName = quote.substring(0, quote.indexOf("("));
            quoteClass = getMethodReturnClass(methodName,clazz);
        }
        //如果没有拿到相关类型，也没必要下一步了
        if(quoteClass == null){
            return null;
        }
        List<String> methods = new ArrayList<>(Arrays.asList(split));
        methods.remove(0);
        for (String method : methods) {
            if(!method.contains("(")){
                //如果不是方法，那就肯定是点的属性了，通过反射去取属性类型
                try {
                    quoteClass = quoteClass.getDeclaredField(method).getType();
                    continue;
                } catch (Exception e) {
                    //取不到属性，也没必要继续了
                    return null;
                }
            }
            //不是属性，那就是方法了
            String methodName = method.substring(0, method.indexOf("("));
            quoteClass = getMethodReturnClass(methodName,quoteClass);
        }
        return quoteClass;
    }
}
