package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.interview.dto.DoSimpleUnitDto;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.DoSimpleUnitVo;
import cn.easyutil.easyapi.logic.unit.ComplexTestProcess;
import cn.easyutil.easyapi.mybatis.service.InterfaceService;
import cn.easyutil.easyapi.mybatis.service.SimpleUnitService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.http.HttpRes;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

/**
 * 单元测试
 */
@RestController
@ConditionalOnMissingBean(name = "easyapiUnitController")
@RequestMapping("/easyapi/doc/unit")
public class UnitController {

    private final SimpleUnitService simpleUnitService = new SimpleUnitService();

    private final InterfaceService interfaceService = new InterfaceService();

    @ApidocComment("保存测试记录")
    @PostMapping("/saveUnit")
    @AccessAuth(code = 1000)
    public void saveUnit(@RequestBody DBSimpleUnitEntity entity){
        AssertUtil.isNull(entity.getInterfaceUnique(),"未知接口");
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        entity.setType(1);
        simpleUnitService.save(entity);
    }

    @ApidocComment("获取接口测试历史记录")
    @AccessAuth(code = 1000)
    public List<DBSimpleUnitEntity> getAllUnit(@RequestBody DBSimpleUnitEntity dto){
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setInterfaceUnique(dto.getInterfaceUnique());
        unit.setUserId(CurrentSession.getCurrentUser().getId());
//        unit.setProjectId(CurrentSession.getCurrentProjectId());
        return simpleUnitService.list(Wrappers.lambdaQuery(unit).orderByDesc(DBSimpleUnitEntity::getCreateTime));
    }

    @ApidocComment("获取上次接口执行相关参数")
    @AccessAuth(code = 1000)
    public DBSimpleUnitEntity getLastUnit(@RequestBody DBSimpleUnitEntity dto){
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setInterfaceUnique(dto.getInterfaceUnique());
        unit.setType(0);
        unit.setUserId(CurrentSession.getCurrentUser().getId());
//        unit.setProjectId(CurrentSession.getCurrentProjectId());
        return simpleUnitService.getOne(Wrappers.lambdaQuery(unit),false);
    }

    @ApidocComment("修改执行结果")
    @AccessAuth(code = 1000)
    public void updateUnit(@RequestBody DBSimpleUnitEntity entity){
        AssertUtil.isNull(entity.getId(),"缺少id");
        simpleUnitService.updateById(entity);
    }

    @ApidocComment("删除测试记录")
    @AccessAuth(code = 1000)
    public void delUnit(@RequestBody IdDto dto){
        simpleUnitService.removeById(dto.getId());
    }

    @ApidocComment("执行网络请求")
    @AccessAuth(code = 1000)
    public DoSimpleUnitVo doSimpleUnit(@RequestBody DoSimpleUnitDto entity){
        //将执行记录保存到DB
        Long userId = CurrentSession.getCurrentUser().getId();
        Long interfaceId = entity.getInterfaceId();
        String jsonParams = entity.getSaveParamsJson();
        String jsonHeaders = entity.getSaveHeadersJson();
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setProjectId(CurrentSession.getCurrentProjectId());
        DBModuleInterfaceEntity info = interfaceService.getById(interfaceId);
        unit.setInterfaceUnique(info.getInterfaceUnique());
        unit.setUserId(userId);
        unit.setType(0);

        simpleUnitService.remove(Wrappers.lambdaQuery(unit));
        unit.setName("LATEST");
        unit.setRequestUrl(entity.getSaveUrl());
        unit.setJsonHeaders(jsonHeaders);
        unit.setJsonParameters(jsonParams);
        unit.setUseStyleType(entity.getUseStyleType());
        unit.setJsonPackages(entity.getSavePackageJson());
        unit.setJsonTables(entity.getSaveTableJson());
        unit.setJsonPreScripts(entity.getSavePreScripts()==null?"[]":entity.getSavePreScripts());
        unit.setJsonPostScripts(entity.getSavePostScripts()==null?"[]":entity.getSavePostScripts());
        simpleUnitService.save(unit);

        //执行远程请求
        long startTime = System.currentTimeMillis();
        HttpRes httpRes = ComplexTestProcess.doUrl(entity, true);
        long endTime = System.currentTimeMillis();
        httpRes.getResponseMsg();

        //记录请求结果
        String responseMsg = httpRes.getResponseMsg();
        unit.setJsonResponse(responseMsg);
        unit.setJsonResHeaders(JsonUtil.beanToJson(httpRes.getResponseHeaders()));
        unit.setAnswerTime(endTime-startTime);

        //准备返回数据
        DoSimpleUnitVo result = new DoSimpleUnitVo();
        result.setResponseCode(httpRes.getResponseCode());
        result.setResponseMsg(httpRes.getResponseMsg());
        if(JsonUtil.isJson(httpRes.getResponseMsg())){
            //如果是json，则转成对象返回出去
            try {
                Map<String, Object> map = JsonUtil.jsonToMap(httpRes.getResponseMsg());
                result.setResponseMsg(map);
            }catch (Exception e) {
                result.setResponseMsg(httpRes.getResponseMsg());
            }
        }
        result.setResponseHeaders(httpRes.getResponseHeaders());
        result.setAnswerTime(endTime-startTime);
        result.setUnitId(unit.getId());
        result.setResponseBase64(httpRes.getResponseBase64());

        unit.setJsonResponse(httpRes.getResponseMsg());
        unit.setResponseBase64(result.getResponseBase64());
        simpleUnitService.updateById(unit);
        return result;
    }
}
