package cn.easyutil.easyapi.filter.readInterface.model;

import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaces;
import org.springframework.web.bind.annotation.*;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class InterfacesCommentReader implements ReadInterfaces {
    @Override
    public List<Method> readAllInterfaces(Class controller, ApiExtra extra) {
        List<Method> result = new ArrayList<>();
        Method[] methods = controller.getDeclaredMethods();
        for (Method method : methods) {
            Annotation[] ans = method.getDeclaredAnnotations();
            for (Annotation an : ans) {
                if (an instanceof RequestMapping) {
                    result.add(method);
                } else if (an instanceof GetMapping) {
                    result.add(method);
                } else if (an instanceof PostMapping) {
                    result.add(method);
                } else if (an instanceof PutMapping) {
                    result.add(method);
                } else if (an instanceof DeleteMapping) {
                    result.add(method);
                }
            }
        }
        return result;
    }
}
