package cn.easyutil.easyapi.filter.readBean.model;

import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.readBean.ReadBeanShow;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.util.AnnotationUtil;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public class BeanShowSwaggerReader implements ReadBeanShow {
    @Override
    public Boolean show(Type type, GenericTypeBind bind, ApiExtra extra) {
        if(extra.getModelField() == null){
            return true;
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiModelProperty", extra.getModelField().getAnnotations());
        if(annotation != null){
            Object hidden = AnnotationUtil.getAnnotationValue(annotation, "hidden");
            if(hidden!=null && hidden instanceof Boolean){
                Boolean h = (Boolean) hidden;
                return !h;
            }
        }
        return null;
    }
}
