package cn.easyutil.easyapi.filter.operator;

import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ApidocCommentUtil;
import cn.easyutil.easyapi.filter.DefaultReaderEnum;
import cn.easyutil.easyapi.filter.config.ReadControllerConfig;
import cn.easyutil.easyapi.filter.readController.*;
import cn.easyutil.easyapi.util.SpringUtil;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ReadControllerOperator implements ReadControllerAuthor
        , ReadControllerDescription
        , ReadControllerIgnore
        , ReadControllerRequestPath
        , ReadControllers
        , ReadControllerShow
        , ReadControllerShowName {

    private final ReadControllerConfig config;

    public ReadControllerOperator(ReadControllerConfig config) {
        if(config == null){
            config = new ReadControllerConfig();
        }
        this.config = config;
        //添加默认实现
        addDefault();
    }

    private void addDefault(){
        config.getReadAuthors().addAll(DefaultReaderEnum.getDefaults(ReadControllerAuthor.class));
        config.getReadControllers().addAll(DefaultReaderEnum.getDefaults(ReadControllers.class));
        config.getReadDescriptions().addAll(DefaultReaderEnum.getDefaults(ReadControllerDescription.class));
        config.getReadIgnores().addAll(DefaultReaderEnum.getDefaults(ReadControllerIgnore.class));
        config.getReadRequestPaths().addAll(DefaultReaderEnum.getDefaults(ReadControllerRequestPath.class));
        config.getReadShowNames().addAll(DefaultReaderEnum.getDefaults(ReadControllerShowName.class));
        config.getReadShows().addAll(DefaultReaderEnum.getDefaults(ReadControllerShow.class));
    }

    @Override
    public String author(Class controller, ApiExtra extra) {
        for (ReadControllerAuthor readAuthor : config.getReadAuthors()) {
            String author = readAuthor.author(controller, extra);
            if(!StringUtil.isEmpty(author)){
                return author;
            }
        }
        return "";
    }

    @Override
    public String description(Class controller, ApiExtra extra) {
        for (ReadControllerDescription readDescription : config.getReadDescriptions()) {
            String description = readDescription.description(controller, extra);
            if(!StringUtil.isEmpty(description)){
                return description;
            }
        }
        return "";
    }

    @Override
    public Boolean ignore(Class controller, ApiExtra extra) {
        for (ReadControllerIgnore readIgnore : config.getReadIgnores()) {
            Boolean ignore = readIgnore.ignore(controller, extra);
            if(ignore != null){
                return ignore;
            }
        }
        if(extra.getControllerComment()!=null && !StringUtil.isEmpty(extra.getControllerComment().getComment())){
            String ignore = ApidocCommentUtil.getCommentValue(extra.getControllerComment().getComment(), "ignore");
            if(!StringUtil.isEmpty(ignore)){
                return ignore.equalsIgnoreCase("true");
            }
        }
        return ApidocCommentUtil.isMatchPath("org.springframework.**",controller.getCanonicalName());
    }

    @Override
    public String requestPath(Class controller, ApiExtra extra) {
        for (ReadControllerRequestPath readRequestPath : config.getReadRequestPaths()) {
            String requestPath = readRequestPath.requestPath(controller, extra);
            if(!StringUtil.isEmpty(requestPath)){
                return requestPath;
            }
        }
        String mapping = SpringUtil.getRequestPath(controller);
        if(StringUtil.isEmpty(mapping)){
            return "";
        }
        return parseUrl(mapping);
    }

    @Override
    public Boolean show(Class controller, ApiExtra extra) {
        for (ReadControllerShow readShow : config.getReadShows()) {
            Boolean show = readShow.show(controller, extra);
            if(show != null){
                return show;
            }
        }
        if(extra.getControllerComment()!=null && !StringUtil.isEmpty(extra.getControllerComment().getComment())){
            String hidden = ApidocCommentUtil.getCommentValue(extra.getControllerComment().getComment(), "hidden");
            if(!StringUtil.isEmpty(hidden)){
                return hidden.equalsIgnoreCase("false");
            }
        }
        return true;
    }

    @Override
    public String showName(Class controller, ApiExtra extra) {
        for (ReadControllerShowName readShowName : config.getReadShowNames()) {
            String showName = readShowName.showName(controller, extra);
            if(!StringUtil.isEmpty(showName)){
                return showName;
            }
        }
        return controller.getSimpleName();
    }

    @Override
    public Set<Class> readControllers(ApplicationContext springContext) {
        for (ReadControllers readController : config.getReadControllers()) {
            Set<Class> controllers = readController.readControllers(springContext);
            if(controllers != null){
                return controllers;
            }
        }
        Map<String, Object> beansWithAnnotation = springContext.getBeansWithAnnotation(Controller.class);
        Set<Class> set = new HashSet<>();
        Iterator<Map.Entry<String, Object>> iterator = beansWithAnnotation.entrySet().iterator();
        while (iterator.hasNext()){
            Map.Entry<String, Object> next = iterator.next();
            Object value = next.getValue();
            Class<?> aClass = value.getClass();
            if(aClass.getCanonicalName().contains("cn.easyutil.easyapi")){
                continue;
            }
            if(aClass.getCanonicalName().contains("$$")){
                set.add(aClass.getSuperclass());
                continue;
            }
            set.add(aClass);
        }
        return set;
    }

    /**
     * 完善请求路径
     *
     * @param requestUrl
     * @return
     */
    private String parseUrl(String requestUrl) {
        if(StringUtil.isEmpty(requestUrl)){
            return null;
        }
        if (!requestUrl.startsWith("/")) {
            requestUrl = "/" + requestUrl;
        }
        if (requestUrl.endsWith("/")) {
            requestUrl = requestUrl.substring(0, requestUrl.length() - 1);
        }
        return requestUrl;
    }
}
