package cn.easyutil.easyapi.filter;

import cn.easyutil.easyapi.filter.readBean.*;
import cn.easyutil.easyapi.filter.readBean.model.*;
import cn.easyutil.easyapi.filter.readController.*;
import cn.easyutil.easyapi.filter.readController.model.*;
import cn.easyutil.easyapi.filter.readInterface.*;
import cn.easyutil.easyapi.filter.readInterface.model.*;
import cn.easyutil.easyapi.filter.readMock.ReadMockTemplate;
import cn.easyutil.easyapi.filter.readMock.model.MockTemplateCommentReader;
import cn.easyutil.easyapi.filter.readReq.*;
import cn.easyutil.easyapi.filter.readReq.model.*;
import cn.easyutil.easyapi.filter.readRes.ReadResponseDescription;
import cn.easyutil.easyapi.filter.readRes.ReadResponseMockTemplate;
import cn.easyutil.easyapi.filter.readRes.ReadResponseReturnTypes;
import cn.easyutil.easyapi.filter.readRes.model.*;
import cn.easyutil.easyapi.util.ObjectUtil;

import java.util.ArrayList;
import java.util.List;

public enum DefaultReaderEnum {

    /*  controller  */
    controllerAuthor1(ReadControllerAuthor.class, ControllerAuthorApiReader.class),
    controllerAuthor3(ReadControllerAuthor.class, ControllerAuthorSwaggerReader.class),
    controllerAuthor2(ReadControllerAuthor.class, ControllerAuthorCommentReader.class),
    controllerDesc1(ReadControllerDescription.class, ControllerDescApiReader.class),
    controllerDesc3(ReadControllerDescription.class, ControllerDescSwaggerReader.class),
    controllerDesc2(ReadControllerDescription.class, ControllerDescCommentReader.class),
    controllerIgnore1(ReadControllerIgnore.class,ControllerIgnoreApiReader.class),
    controllerIgnore3(ReadControllerIgnore.class,ControllerIgnoreSwaggerReader.class),
    controllerIgnore2(ReadControllerIgnore.class,ControllerIgnoreCommentReader.class),
    controllerRequestPath1(ReadControllerRequestPath.class,ControllerRequestPathApiReader.class),
    controllerRequestPath3(ReadControllerRequestPath.class,ControllerRequestPathSwaggerReader.class),
    controllerRequestPath2(ReadControllerRequestPath.class,ControllerRequestPathCommentReader.class),
    controllerShow1(ReadControllerShow.class,ControllerShowApiReader.class),
    controllerShow3(ReadControllerShow.class,ControllerShowSwaggerReader.class),
    controllerShow2(ReadControllerShow.class,ControllerShowCommentReader.class),
    controllerShowName1(ReadControllerShowName.class,ControllerShowNameApiReader.class),
    controllerShowName3(ReadControllerShowName.class,ControllerShowNameSwaggerReader.class),
    controllerShowName2(ReadControllerShowName.class,ControllerShowNameCommentReader.class),

    /* interface */
    interfaceBodyType1(ReadInterfaceBodyType.class, InterfaceBodyTypeCommentReader.class),
    interfaceDesc1(ReadInterfaceDescription.class, InterfaceDescApiReader.class),
    interfaceDesc2(ReadInterfaceDescription.class, InterfaceDescSwaggerReader.class),
    interfaceIgnore1(ReadInterfaceIgnore.class, InterfaceIgnoreApiReader.class),
    interfaceIgnore2(ReadInterfaceIgnore.class, InterfaceIgnoreSwaggerReader.class),
    interfaceRequestMd1(ReadInterfaceRequestMethod.class,InterfaceRequestMethodCommentReader.class),
    interfaceRequestUrl1(ReadInterfaceRequestUrl.class,InterfaceRequestUrlCommentReader.class),
    interfaces1(ReadInterfaces.class,InterfacesCommentReader.class),
    interfaceShow1(ReadInterfaceShow.class,InterfaceShowApiReader.class),
    interfaceShowName1(ReadInterfaceShowName.class,InterfaceShowNameApiReader.class),
    interfaceShowName2(ReadInterfaceShowName.class,InterfaceShowNameSwaggerReader.class),
    interfaceShowName3(ReadInterfaceShowName.class,InterfaceShowNameCommentReader.class),
    interfaceUnique1(ReadInterfaceUnique.class,InterfaceUniqueCommentReader.class),
    interfaceVerifyMockTag1(ReadInterfaceVerifyMockTag.class,InterfaceVerifyMockTagCommentReader.class),

    /* bean */
    beanCondition1(ReadBeanCondition.class, BeanConditionCommentReader.class),
    beanDesc1(ReadBeanDescription.class, BeanDescriptionApiReader.class),
    beanDesc2(ReadBeanDescription.class, BeanDescriptionSwaggerReader.class),
    beanDesc3(ReadBeanDescription.class, BeanDescriptionCommentReader.class),
    beanIgnore1(ReadBeanIgnore.class, BeanIgnoreApiReader.class),
    beanIgnore2(ReadBeanIgnore.class, BeanIgnoreCommentReader.class),
    beanJavaType1(ReadBeanJavaType.class,BeanJavaTypeCommentReader.class),
    beanMockTemplate1(ReadBeanMockTemplate.class,BeanMockTemplateCommentReader.class),
    beanParams1(ReadBeanParams.class,BeanParamsCommentReader.class),
    beanRequired1(ReadBeanRequired.class,BeanRequiredApiReader.class),
    beanRequired2(ReadBeanRequired.class,BeanRequiredSwaggerReader.class),
    beanShow1(ReadBeanShow.class,BeanShowApiReader.class),
    beanShow2(ReadBeanShow.class,BeanShowSwaggerReader.class),
    beanType1(ReadBeanType.class,BeanTypeCommentReader.class),

    /* mock */
    mockTemplate1(ReadMockTemplate.class, MockTemplateCommentReader.class),

    /* request */
    requestConditon1(ReadRequestCondition.class, RequestConditionCommentReader.class),
    requestDesc1(ReadRequestDescription.class, RequestDescriptionApiReader.class),
    requestDesc2(ReadRequestDescription.class, RequestDescriptionSwaggerReader.class),
    requestDesc3(ReadRequestDescription.class, RequestDescriptionCommentReader.class),
    requestIgnore1(ReadRequestIgnore.class, RequestIgnoreCommentReader.class),
    requestMockTemplate1(ReadRequestMockTemplate.class,RequestMockTemplateCommentReader.class),
    requestName1(ReadRequestName.class,RequestNameCommentReader.class),
    requestParams1(ReadRequestParams.class,RequestParamsCommentReader.class),
    requestType1(ReadRequestType.class,RequestTypeCommentReader.class),

    /* response */
    responseDesc1(ReadResponseDescription.class, ResponseDescriptionCommentReader.class),
    responseMockTemplate1(ReadResponseMockTemplate.class, ResponseMockTemplateCommentReader.class),
    responseReturnType2(ReadResponseReturnTypes.class, ResponseRetrunTypesCommentReader.class),


    none(null,null);
    Class<?> filter;
    Class<?> defaultClass;

    DefaultReaderEnum(Class<?> filter, Class<?> defaultClass) {
        this.filter = filter;
        this.defaultClass = defaultClass;
    }

    public static <T>List<T> getDefaults(Class<T> filter){
        DefaultReaderEnum[] values = DefaultReaderEnum.values();
        List<T> list = new ArrayList<>();
        for (DefaultReaderEnum value : values) {
            if(filter.equals(value.filter)){
                Object o = ObjectUtil.newInstance(value.defaultClass);
                list.add((T)o);
            }
        }
        return list;
    }
}
