package cn.easyutil.easyapi.util.http;

import java.util.Arrays;
import java.util.List;

/**
 * http工厂创建
 */
public class HttpUtilFactory {

    public static HttpOperation create(HttpImplEnum httpImplEnum){
        switch (httpImplEnum){
            case jdk:
                return new JdkHttpOperation();
            case httpClient:
                return new HttpClientOperation();
        }
        return new HttpClientOperation();
    }

    public static HttpOperation fastCreate(String url,HttpMethod method){
        return new HttpClientOperation(url,method);
    }

    public static HttpOperation fastCreate(String url,String method){
        return new HttpClientOperation(url,HttpMethod.get(method));
    }
}
