package cn.easyutil.easyapi.util.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * http请求体
 */
public class HttpReq {

    //请求路径
    private String url;

    //请求方法
    private HttpMethod method;

    //请求参数
    private Map params = new HashMap<>();

    //文件参数
    private List<HttpFileReq> fileParams = new ArrayList<>();

    //请求头
    private Map<String,String> header = new HashMap<>();

    //连接超时时间，默认60s
    private int connectTimeOut = 60*1000;

    //非formdata类型的参数无key
    public static final String nullKeyParam = "_null";


    public void addHeader(String key,String val){
        this.header.put(key, val);
    }

    public void addHeader(Map headers){
        if(headers == null){
            return ;
        }
        headers.keySet().stream().forEach(k -> {
            addHeader(k.toString(),headers.get(k).toString());
        });
    }

    public void addParam(String key, Object val) {
        this.params.put(key, val.toString());
    }

    public void addParam(String param){
        this.params.put(nullKeyParam, param);
    }

    public void addParam(Map params){
        this.params.putAll(params);
    }

    public void addFileParam(HttpFileReq fileReq){
        this.fileParams.add(fileReq);
    }

    public void setParam(Map params){
        this.params = params;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HttpMethod getMethod() {
        return method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public Map getParams() {
        if(params == null){
            return new HashMap();
        }
        return params;
    }

    public Map<String, String> getHeader() {
        if(header == null){
            return new HashMap<>();
        }
        return header;
    }

    public void setHeader(Map<String, String> header) {
        this.header = header;
    }

    public int getConnectTimeOut() {
        return connectTimeOut;
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public List<HttpFileReq> getFileParams() {
        if(fileParams == null){
            return new ArrayList<>();
        }
        return fileParams;
    }

    public void setFileParams(List<HttpFileReq> fileParams) {
        this.fileParams = fileParams;
    }

}
