package cn.easyutil.easyapi.filter.readInterface.model;

import cn.easyutil.easyapi.entity.common.BodyType;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceBodyType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.multipart.MultipartFile;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class InterfaceBodyTypeCommentReader implements ReadInterfaceBodyType {
    @Override
    public BodyType bodyType(Method method, ApiExtra extra) {
        Parameter[] parameters = method.getParameters();
        if (parameters == null || parameters.length == 0) {
            // 无入参
            return BodyType.FORM;
        }
        for (Parameter parameter : parameters) {
            RequestBody annotation = parameter.getAnnotation(RequestBody.class);
            if (annotation != null) {
                return BodyType.JSON;
            }
            // 文件上传
            if (parameter.getType().getCanonicalName().equals(MultipartFile.class.getCanonicalName())
                    || parameter.getType().getCanonicalName().equals(MultipartFile[].class.getCanonicalName())) {
                return BodyType.UPLOAD;
            }
        }
        return null;
    }
}
