package cn.easyutil.easyapi.filter.operator;

import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ApidocCommentUtil;
import cn.easyutil.easyapi.filter.DefaultReaderEnum;
import cn.easyutil.easyapi.filter.config.ReadRequestConfig;
import cn.easyutil.easyapi.filter.readReq.*;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.javadoc.reader.SourceParameterComment;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ReadRequestOperator implements ReadRequestCondition
        , ReadRequestDescription
        , ReadRequestIgnore
        , ReadRequestMockTemplate
        , ReadRequestName
        ,ReadRequestParams
        ,ReadRequestRequired
        ,ReadRequestShow
        ,ReadRequestType {

    private final ReadRequestConfig config;

    public ReadRequestOperator(ReadRequestConfig config) {
        if(config == null){
            config = new ReadRequestConfig();
        }
        this.config = config;
        addDefaults();
    }

    private void addDefaults(){
        config.getReadParams().addAll(DefaultReaderEnum.getDefaults(ReadRequestParams.class));
        config.getReadConditions().addAll(DefaultReaderEnum.getDefaults(ReadRequestCondition.class));
        config.getReadDescriptions().addAll(DefaultReaderEnum.getDefaults(ReadRequestDescription.class));
        config.getReadIgnore().addAll(DefaultReaderEnum.getDefaults(ReadRequestIgnore.class));
        config.getReadMockTemplate().addAll(DefaultReaderEnum.getDefaults(ReadRequestMockTemplate.class));
        config.getReadName().addAll(DefaultReaderEnum.getDefaults(ReadRequestName.class));
        config.getReadRequired().addAll(DefaultReaderEnum.getDefaults(ReadRequestRequired.class));
        config.getReadShow().addAll(DefaultReaderEnum.getDefaults(ReadRequestShow.class));
        config.getReadType().addAll(DefaultReaderEnum.getDefaults(ReadRequestType.class));
    }

    @Override
    public List<String> conditions(Type parameterType, ApiExtra extra) {
        for (ReadRequestCondition readCondition : config.getReadConditions()) {
            List<String> conditions = readCondition.conditions(parameterType, extra);
            if(conditions!=null && conditions.size()>0){
                return conditions;
            }
        }
        return new ArrayList<>();
    }

    @Override
    public String description(Type parameterType, String parameterName, ApiExtra extra) {
        for (ReadRequestDescription readDescription : config.getReadDescriptions()) {
            String description = readDescription.description(parameterType, parameterName, extra);
            if(!StringUtil.isEmpty(description)){
                return description;
            }
        }
        return "";
    }

    @Override
    public Boolean ignore(Type parameterType, Class parameterClass, ApiExtra extra) {
        for (ReadRequestIgnore readRequestIgnore : config.getReadIgnore()) {
            Boolean ignore = readRequestIgnore.ignore(parameterType, parameterClass, extra);
            if(ignore != null){
                return ignore;
            }
        }
        MethodComment methodComment = extra.getMethodComment();
        if(methodComment!=null && !StringUtil.isEmpty(extra.getModelName()) && methodComment.getParameter(extra.getModelName())!=null){
            SourceParameterComment parameter = methodComment.getParameter(extra.getModelName());
            if(!StringUtil.isEmpty(parameter.getComment())){
                String ignore = ApidocCommentUtil.getCommentValue(parameter.getComment(), "ignore");
                if(!StringUtil.isEmpty(ignore)){
                    return ignore.equalsIgnoreCase("true");
                }
            }
        }
        return false;
    }

    @Override
    public String mockTemplate(Type parameterType, ApiExtra extra) {
        for (ReadRequestMockTemplate readRequestMockTemplate : config.getReadMockTemplate()) {
            String s = readRequestMockTemplate.mockTemplate(parameterType, extra);
            if(!StringUtil.isEmpty(s)){
                return s;
            }
        }
        return "";
    }

    @Override
    public String parameterName(Type parameterType,String parameterName, ApiExtra extra) {
        for (ReadRequestName readRequestName : config.getReadName()) {
            String s = readRequestName.parameterName(parameterType, parameterName, extra);
            if(!StringUtil.isEmpty(s)){
                return s;
            }
        }
        return parameterName;
    }

    @Override
    public void params(List<MethodParam> params, ApiExtra extra) {
        if(params == null){
            params = new ArrayList<>();
        }
        for (ReadRequestParams readParam : config.getReadParams()) {
            readParam.params(params, extra);
        }
    }

    @Override
    public Boolean required(Type parameterType, ApiExtra extra) {
        for (ReadRequestRequired readRequestRequired : config.getReadRequired()) {
            Boolean required = readRequestRequired.required(parameterType, extra);
            if(required != null){
                return required;
            }
        }
        if(extra.getMethodComment()!=null && !StringUtil.isEmpty(extra.getModelName()) && extra.getMethodComment().getParameter(extra.getModelName())!=null){
            String required = ApidocCommentUtil.getCommentValue(extra.getMethodComment().getParameter(extra.getModelName()).getComment(), "required");
            if(!StringUtil.isEmpty(required)){
                return required.equalsIgnoreCase("true");
            }
        }
        return true;
    }

    @Override
    public Boolean show(Type parameterType, ApiExtra extra) {
        for (ReadRequestShow readRequestShow : config.getReadShow()) {
            Boolean show = readRequestShow.show(parameterType, extra);
            if(show != null){
                return show;
            }
        }
        if(extra.getMethodComment()!=null && !StringUtil.isEmpty(extra.getModelName()) && extra.getMethodComment().getParameter(extra.getModelName())!=null){
            String hidden = ApidocCommentUtil.getCommentValue(extra.getMethodComment().getParameter(extra.getModelName()).getComment(), "hidden");
            if(!StringUtil.isEmpty(hidden)){
                return hidden.equalsIgnoreCase("false");
            }
        }
        return true;
    }

    @Override
    public Type parameterType(Type parameterType,String parameterName, ApiExtra extra) {
        for (ReadRequestType readRequestType : config.getReadType()) {
            Type type = readRequestType.parameterType(parameterType,parameterName, extra);
            if(type != null){
                return type;
            }
        }
        return parameterType;
    }
}
