package cn.easyutil.easyapi.filter.operator;

import cn.easyutil.easyapi.entity.common.BodyType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ApidocCommentUtil;
import cn.easyutil.easyapi.filter.DefaultReaderEnum;
import cn.easyutil.easyapi.filter.config.ReadInterfaceConfig;
import cn.easyutil.easyapi.filter.readInterface.*;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ReadInterfaceOperator implements ReadInterfaceBodyType
        , ReadInterfaceCustomSearch
        , ReadInterfaceDescription
        , ReadInterfaceEnableReqPackage
        , ReadInterfaceEnableResPackage
        ,ReadInterfaceIgnore
        ,ReadInterfaceRenewType
        ,ReadInterfaceRequestUrl
        ,ReadInterfaceRequestMethod
        ,ReadInterfaces
        ,ReadInterfaceShow
        ,ReadInterfaceShowName
        ,ReadInterfaceUnique
        ,ReadInterfaceRequestParamRemark
        ,ReadInterfaceResponseParamRemark
        ,ReadInterfaceVerifyMockTag {

    private final ReadInterfaceConfig config;

    public ReadInterfaceOperator(ReadInterfaceConfig config) {
        if(config == null){
            config = new ReadInterfaceConfig();
        }
        this.config = config;
        //添加默认实现
        addDefault();
    }

    private void addDefault(){
        config.getReadBodyTypes().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceBodyType.class));
        config.getReadCustomSearch().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceCustomSearch.class));
        config.getReadDescription().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceDescription.class));
        config.getReadIgnore().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceIgnore.class));
        config.getReadInterfaces().addAll(DefaultReaderEnum.getDefaults(ReadInterfaces.class));
        config.getReadRenewTypes().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceRenewType.class));
        config.getReadReqPackages().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceEnableReqPackage.class));
        config.getReadResPackages().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceEnableResPackage.class));
        config.getReadRequestMethods().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceRequestMethod.class));
        config.getReadRequestUrls().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceRequestUrl.class));
        config.getReadShowNames().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceShowName.class));
        config.getReadShows().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceShow.class));
        config.getReadUniques().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceUnique.class));
        config.getReadVerifyMockTags().addAll(DefaultReaderEnum.getDefaults(ReadInterfaceVerifyMockTag.class));
    }

    @Override
    public BodyType bodyType(Method method, ApiExtra extra) {
        for (ReadInterfaceBodyType readBodyType : config.getReadBodyTypes()) {
            BodyType bodyType = readBodyType.bodyType(method, extra);
            if(bodyType != null){
                return bodyType;
            }
        }
        return BodyType.FORM;
    }

    @Override
    public List<String> customSearch(Method method, ApiExtra extra) {
        for (ReadInterfaceCustomSearch readCustomSearch : config.getReadCustomSearch()) {
            List<String> list = readCustomSearch.customSearch(method, extra);
            if(list!=null && !list.isEmpty()){
                return list;
            }
        }
        return new ArrayList<>();
    }

    @Override
    public String description(Method method, ApiExtra extra) {
        for (ReadInterfaceDescription readInterfaceDescription : config.getReadDescription()) {
            String description = readInterfaceDescription.description(method, extra);
            if(!StringUtil.isEmpty(description)){
                return description;
            }
        }
        if(extra.getMethodComment()!=null && !StringUtil.isEmpty(extra.getMethodComment().getComment())){
            String notes = ApidocCommentUtil.getCommentValue(extra.getMethodComment().getComment(), "notes");
            if(!StringUtil.isEmpty(notes)){
                return notes;
            }
        }
        return "";
    }

    @Override
    public Boolean enableReqPackage(Method method, ApiExtra extra) {
        for (ReadInterfaceEnableReqPackage readReqPackage : config.getReadReqPackages()) {
            Boolean toPackage = readReqPackage.enableReqPackage(method, extra);
            if(toPackage != null){
                return toPackage;
            }
        }
        return false;
    }

    @Override
    public Boolean enableResPackage(Method method, ApiExtra extra) {
        for (ReadInterfaceEnableResPackage readResPackage : config.getReadResPackages()) {
            Boolean toPackage = readResPackage.enableResPackage(method, extra);
            if(toPackage != null){
                return toPackage;
            }
        }
        return false;
    }

    @Override
    public Boolean ignore(Method method, ApiExtra extra) {
        for (ReadInterfaceIgnore readInterfaceIgnore : config.getReadIgnore()) {
            Boolean ignore = readInterfaceIgnore.ignore(method, extra);
            if(ignore != null){
                return ignore;
            }
        }
        if(extra.getMethodComment()!=null && !StringUtil.isEmpty(extra.getMethodComment().getComment())){
            String ignore = ApidocCommentUtil.getCommentValue(extra.getMethodComment().getComment(), "ignore");
            if(!StringUtil.isEmpty(ignore)){
                return ignore.equalsIgnoreCase("true");
            }
        }
        return false;
    }

    @Override
    public RenewType renewType(Method method, ApiExtra extra) {
        for (ReadInterfaceRenewType readRenewType : config.getReadRenewTypes()) {
            RenewType renewType = readRenewType.renewType(method, extra);
            if(renewType != null){
                return renewType;
            }
        }
        return RenewType.increment;
    }

    @Override
    public RequestMethod requestMethod(Method method, ApiExtra extra) {
        for (ReadInterfaceRequestMethod readRequestMethod : config.getReadRequestMethods()) {
            RequestMethod requestMethod = readRequestMethod.requestMethod(method, extra);
            if(requestMethod != null){
                return requestMethod;
            }
        }
        return RequestMethod.POST;
    }

    @Override
    public String requestUrl(Method method, ApiExtra extra) {
        for (ReadInterfaceRequestUrl readRequestUrl : config.getReadRequestUrls()) {
            String requestUrl = readRequestUrl.requestUrl(method, extra);
            if(!StringUtil.isEmpty(requestUrl)){
                return requestUrl;
            }
        }
        return "";
    }

    @Override
    public Boolean show(Method method, ApiExtra extra) {
        for (ReadInterfaceShow readShow : config.getReadShows()) {
            Boolean show = readShow.show(method, extra);
            if(show != null){
                return show;
            }
        }
        if(extra.getMethodComment()!=null && !StringUtil.isEmpty(extra.getMethodComment().getComment())){
            String hidden = ApidocCommentUtil.getCommentValue(extra.getMethodComment().getComment(), "hidden");
            if(!StringUtil.isEmpty(hidden)){
                return hidden.equalsIgnoreCase("false");
            }
        }
        return true;
    }

    @Override
    public String showName(Method method, ApiExtra extra) {
        for (ReadInterfaceShowName readShowName : config.getReadShowNames()) {
            String name = readShowName.showName(method, extra);
            if(!StringUtil.isEmpty(name)){
                return name;
            }
        }
        return method.getName();
    }

    @Override
    public String unique(Method method, ApiExtra extra) {
        for (ReadInterfaceUnique readUnique : config.getReadUniques()) {
            String unique = readUnique.unique(method, extra);
            if(!StringUtil.isEmpty(unique)){
                return unique;
            }
        }
        return StringUtil.toMD5(method.toGenericString());
    }

    @Override
    public Boolean verifyMockTag(String tag, DBModuleInterfaceEntity entity) {
        for (ReadInterfaceVerifyMockTag readVerifyMockTag : config.getReadVerifyMockTags()) {
            Boolean verifyMockTag = readVerifyMockTag.verifyMockTag(tag, entity);
            if(verifyMockTag != null){
                return verifyMockTag;
            }
        }
        return true;
    }

    @Override
    public List<Method> readAllInterfaces(Class controller, ApiExtra extra) {
        for (ReadInterfaces readInterface : config.getReadInterfaces()) {
            List<Method> methods = readInterface.readAllInterfaces(controller, extra);
            if(methods!=null && methods.size()>0){
                return methods;
            }
        }
        return new ArrayList<>();
    }

    @Override
    public String requestParamRemark(Method method, ApiExtra extra) {
        for (ReadInterfaceRequestParamRemark remark : config.getReadRequestParamRemark()) {
            String s = remark.requestParamRemark(method, extra);
            if(!StringUtil.isEmpty(s)){
                return s;
            }
        }
        if(extra.getMethodComment()!=null && !StringUtil.isEmpty(extra.getMethodComment().getComment())){
            String description = ApidocCommentUtil.getCommentValue(extra.getMethodComment().getComment(), "description");
            if(!StringUtil.isEmpty(description)){
                return description;
            }
        }
        return "暂无说明";
    }

    @Override
    public String responseParamRemark(Method method, ApiExtra extra) {
        for (ReadInterfaceResponseParamRemark remark : config.getReadResponseParamRemark()) {
            String s = remark.responseParamRemark(method, extra);
            if(!StringUtil.isEmpty(s)){
                return s;
            }
        }
        if(extra.getMethodComment()!=null && !StringUtil.isEmpty(extra.getMethodComment().getReturnComment())){
            String description = ApidocCommentUtil.getCommentValue(extra.getMethodComment().getReturnComment(), "description");
            if(!StringUtil.isEmpty(description)){
                return description;
            }
        }
        return "暂无说明";
    }
}
