package cn.easyutil.easyapi.content;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.db.auth.*;
import cn.easyutil.easyapi.entity.db.doc.*;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestGroupEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestInfoEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.mybatis.IBaseMapper;
import cn.easyutil.easyapi.mybatis.MybatisUtil;
import cn.easyutil.easyapi.mybatis.SqlExecMapper;
import cn.easyutil.easyapi.mybatis.mapper.*;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;

public enum DBTables {
    //项目表
    project("EASYAPI_PROJECT",DBTableClassify.global, DBProjectEntity.class, ProjectMapper.class),
    dict("EASYAPI_DICT",DBTableClassify.global,DBDictEntity.class, DictMapper.class),
    roleAuth("EASYAPI_ROLE_AUTH",DBTableClassify.global, DBRoleAuthEntity.class, RoleAuthMapper.class),
    role("EASYAPI_ROLE",DBTableClassify.global, DBRoleEntity.class, RoleMapper.class),
    roleProject("EASYAPI_ROLE_PROJECTS",DBTableClassify.global, DBRoleProjectEntity.class, RoleProjectMapper.class),
    user("EASYAPI_USER",DBTableClassify.user, DBUserEntity.class,UserMapper.class),
    simpleUnit("EASYAPI_SIMPLE_UNIT",DBTableClassify.user, DBSimpleUnitEntity.class,SimpleUnitMapper.class),
    complexTest("EASYAPI_COMPLEX_TEST",DBTableClassify.user, DBComplexTestEntity.class,null),
    complexTestGroup("EASYAPI_COMPLEX_TEST_GROUP",DBTableClassify.user, DBComplexTestGroupEntity.class,null),
    complexTestInfo("EASYAPI_COMPLEX_TEST_INFO",DBTableClassify.user, DBComplexTestInfoEntity.class,null),
    interfaceParam("EASYAPI_INTERFACE_PARAM",DBTableClassify.doc, DBInterfaceParamEntity.class,InterfaceParamMapper.class),
    controllers("EASYAPI_MODULE_CONTROLLER",DBTableClassify.doc, DBModuleControllerEntity.class,ControllerMapper.class),
    module("EASYAPI_MODULE",DBTableClassify.global, DBModuleEntity.class,ModuleMapper.class),
    host("EASYAPI_MODULE_HOST",DBTableClassify.global, DBModuleHostEntity.class,HostMapper.class),
    interfaces("EASYAPI_MODULE_INTERFACE",DBTableClassify.doc,DBModuleInterfaceEntity.class,InterfaceMapper.class),
    outPackage("EASYAPI_MODULE_OUT_PACKAGE",DBTableClassify.user,DBModuleOutPackageEntity.class,OutPackageMapper.class),
    env("EASYAPI_MODULE_ENV",DBTableClassify.user,DBMouduleEnvEntity.class,EnvMapper.class),
    header("EASYAPI_MODULE_HEADER",DBTableClassify.user,DBModuleHeaderEntity.class,HeaderMapper.class),
    script("EASYAPI_MODULE_SCRIPT",DBTableClassify.user,DBModuleScriptEntity.class,ScriptMapper.class),
    param("EASYAPI_PARAM",DBTableClassify.doc,DBParamEntity.class,ParamMapper.class),
    userTemporaryAuth("EASYAPI_USER_TEMPORARY_AUTH",DBTableClassify.user,DBUserTemporaryAuthEntity.class,UserTemporaryAuthMapper.class),
    article("EASYAPI_ARTICLE",DBTableClassify.global,DBArticleEntity.class,ArticleMapper.class),
    ;

    private String tableName;
    private DBTableClassify classify;
    private Class<? extends BaseDbEntity> clazz;
    private Class<? extends IBaseMapper> mapper;

    DBTables(String tableName,DBTableClassify classify,Class<? extends BaseDbEntity> clazz,Class<? extends IBaseMapper> mapper){
        this.tableName = tableName;
        this.classify = classify;
        this.clazz = clazz;
        this.mapper = mapper;
    }

    public String dropSql(){
        return "DROP TABLE IF EXISTS "+this.tableName+";";
    }

    public String clearSql(){
        return "TRUNCATE table "+this.tableName+";";
    }

    public String tableDDL(){
        Class<? extends BaseDbEntity> clazz = this.clazz;
        List<DDL> DDLs = getAllFields(clazz);
        if(DDLs.isEmpty()){
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE if not exists ").append("`").append(this.tableName).append("`");
        sb.append("(").append("\n");
        for (DDL DDL : DDLs) {
            sb.append("\n");
            sb.append(DDL.ddl()).append(",");
        }
        sb.append("\n").append("PRIMARY KEY (`ID`)").append("\n");
        sb.append(")");
        return sb.toString();
    }

    /**
     * 补充缺少的field
     */
    public void replenishField(){
        //先查询已存在的字段名称
        SqlExecMapper mapper = MybatisUtil.getMapper(SqlExecMapper.class);
        List<Map<String, Object>> query = mapper.execQuery("SHOW COLUMNS FROM " + this.tableName);
        Set<String> tableFields = new HashSet<>();
        if(query != null){
            tableFields = query.stream().map(m -> {
                if(m.get("FIELD") != null){
                    return m.get("FIELD").toString();
                }else if(m.get("Field") != null){
                    return m.get("Field").toString();
                }else if(m.get("field") != null){
                    return m.get("field").toString();
                }else {
                    return "";
                }
            }).collect(Collectors.toSet());
        }
        //再获取全部字段名称
        List<DDL> allFields = getAllFields(this.clazz);
        for (DDL DDL : allFields) {
            String name = DDL.value();
            if(!StringUtil.isEmpty(name) && !tableFields.contains(name)){
                //不包含本字段，直接执行ddl
                mapper.execUpdate("ALTER TABLE " + this.tableName + " ADD "+DDL.ddl());
            }
        }
    }

    public List<DDL> getAllFields(Class<? extends BaseDbEntity> clazz){
        List<DDL> DDLs = new ArrayList<>();
        for (Class cl=clazz;!cl.equals(Object.class);cl=cl.getSuperclass()){
            Field[] fields = cl.getDeclaredFields();
            for (Field field : fields) {
                DDL DDL = field.getDeclaredAnnotation(DDL.class);
                if(DDL != null){
                    DDLs.add(DDL);
                }
            }
        }
        return DDLs;
    }

    /**
     * 根据表类型获取表信息
     * @param classify
     * @return
     */
    public static List<DBTables> getByClassify(DBTableClassify classify){
        List<DBTables> result = new ArrayList<>();
        for (DBTables value : DBTables.values()) {
            if(value.classify == classify){
                result.add(value);
            }
        }
        return result;
    }


    public String getTableName() {
        return tableName;
    }

    public DBTableClassify getClassify() {
        return classify;
    }

    public Class<? extends BaseDbEntity> getClazz() {
        return clazz;
    }

    public Class<? extends IBaseMapper> getMapper() {
        return mapper;
    }
}
