package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.filter.readRes.*;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.Set;

@Component
@ConfigurationProperties(prefix = "easyapi.filter.response")
public class EasyApiFilterResponseConfiguration {

    /** 读取接口响应说明*/
    private Set<Class<ReadResponseDescription>> descriptions = new HashSet<>();

    /** 读取接口响应忽略配置*/
    private Set<Class<ReadResponseIgnore>> ignore = new HashSet<>();

    /** 读取接口响应mock模板*/
    private Set<Class<ReadResponseMockTemplate>> mockTemplate = new HashSet<>();

    /** 读取接口响应必填配置*/
    private Set<Class<ReadResponseRequired>> required = new HashSet<>();

    /** 读取接口响应参数类型*/
    private Set<Class<ReadResponseReturnTypes>> returnTypes = new HashSet<>();

    /** 读取接口响应参数的显示和隐藏配置*/
    private Set<Class<ReadResponseShow>> show = new HashSet<>();

    public Set<Class<ReadResponseDescription>> getDescriptions() {
        return descriptions;
    }

    public void setDescriptions(Set<Class<ReadResponseDescription>> descriptions) {
        this.descriptions = descriptions;
    }

    public Set<Class<ReadResponseIgnore>> getIgnore() {
        return ignore;
    }

    public void setIgnore(Set<Class<ReadResponseIgnore>> ignore) {
        this.ignore = ignore;
    }

    public Set<Class<ReadResponseMockTemplate>> getMockTemplate() {
        return mockTemplate;
    }

    public void setMockTemplate(Set<Class<ReadResponseMockTemplate>> mockTemplate) {
        this.mockTemplate = mockTemplate;
    }

    public Set<Class<ReadResponseRequired>> getRequired() {
        return required;
    }

    public void setRequired(Set<Class<ReadResponseRequired>> required) {
        this.required = required;
    }

    public Set<Class<ReadResponseReturnTypes>> getReturnTypes() {
        return returnTypes;
    }

    public void setReturnTypes(Set<Class<ReadResponseReturnTypes>> returnTypes) {
        this.returnTypes = returnTypes;
    }

    public Set<Class<ReadResponseShow>> getShow() {
        return show;
    }

    public void setShow(Set<Class<ReadResponseShow>> show) {
        this.show = show;
    }
}
