package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.filter.readInterface.*;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.Set;

@Component
@ConfigurationProperties(prefix = "easyapi.filter.interface")
public class EasyApiFilterInterfaceConfiguration {

    /** 读取接口请求体类型*/
    private Set<Class<ReadInterfaceBodyType>> readBodyTypes = new HashSet<>();

    /** 读取接口自定义搜索标签*/
    private Set<Class<ReadInterfaceCustomSearch>> readCustomSearch = new HashSet<>();

    /** 读取接口说明*/
    private Set<Class<ReadInterfaceDescription>> readDescription = new HashSet<>();

    /** 读取接口请求参数包装配置*/
    private Set<Class<ReadInterfaceEnableReqPackage>> readReqPackages = new HashSet<>();

    /** 读取接口响应包装配置*/
    private Set<Class<ReadInterfaceEnableResPackage>> readResPackages = new HashSet<>();

    /** 读取接口忽略配置*/
    private Set<Class<ReadInterfaceIgnore>> readIgnore = new HashSet<>();

    /** 读取接口更新策略*/
    private Set<Class<ReadInterfaceRenewType>> readRenewTypes = new HashSet<>();

    /** 读取接口请求方法*/
    private Set<Class<ReadInterfaceRequestMethod>> readRequestMethods = new HashSet<>();

    /** 读取接口请求路径*/
    private Set<Class<ReadInterfaceRequestUrl>> readRequestUrls = new HashSet<>();

    /** 读取全部接口*/
    private Set<Class<ReadInterfaces>> readInterfaces = new HashSet<>();

    /** 读取接口显示隐藏配置*/
    private Set<Class<ReadInterfaceShow>> readShows = new HashSet<>();

    /** 读取接口名称*/
    private Set<Class<ReadInterfaceShowName>> readShowNames = new HashSet<>();

    /** 读取接口唯一标识*/
    private Set<Class<ReadInterfaceUnique>> readUniques = new HashSet<>();

    /** 读取接口是否mock配置*/
    private Set<Class<ReadInterfaceVerifyMockTag>> readVerifyMockTags = new HashSet<>();

    public Set<Class<ReadInterfaceBodyType>> getReadBodyTypes() {
        return readBodyTypes;
    }

    public void setReadBodyTypes(Set<Class<ReadInterfaceBodyType>> readBodyTypes) {
        this.readBodyTypes = readBodyTypes;
    }

    public Set<Class<ReadInterfaceCustomSearch>> getReadCustomSearch() {
        return readCustomSearch;
    }

    public void setReadCustomSearch(Set<Class<ReadInterfaceCustomSearch>> readCustomSearch) {
        this.readCustomSearch = readCustomSearch;
    }

    public Set<Class<ReadInterfaceDescription>> getReadDescription() {
        return readDescription;
    }

    public void setReadDescription(Set<Class<ReadInterfaceDescription>> readDescription) {
        this.readDescription = readDescription;
    }

    public Set<Class<ReadInterfaceEnableReqPackage>> getReadReqPackages() {
        return readReqPackages;
    }

    public void setReadReqPackages(Set<Class<ReadInterfaceEnableReqPackage>> readReqPackages) {
        this.readReqPackages = readReqPackages;
    }

    public Set<Class<ReadInterfaceEnableResPackage>> getReadResPackages() {
        return readResPackages;
    }

    public void setReadResPackages(Set<Class<ReadInterfaceEnableResPackage>> readResPackages) {
        this.readResPackages = readResPackages;
    }

    public Set<Class<ReadInterfaceIgnore>> getReadIgnore() {
        return readIgnore;
    }

    public void setReadIgnore(Set<Class<ReadInterfaceIgnore>> readIgnore) {
        this.readIgnore = readIgnore;
    }

    public Set<Class<ReadInterfaceRenewType>> getReadRenewTypes() {
        return readRenewTypes;
    }

    public void setReadRenewTypes(Set<Class<ReadInterfaceRenewType>> readRenewTypes) {
        this.readRenewTypes = readRenewTypes;
    }

    public Set<Class<ReadInterfaceRequestMethod>> getReadRequestMethods() {
        return readRequestMethods;
    }

    public void setReadRequestMethods(Set<Class<ReadInterfaceRequestMethod>> readRequestMethods) {
        this.readRequestMethods = readRequestMethods;
    }

    public Set<Class<ReadInterfaceRequestUrl>> getReadRequestUrls() {
        return readRequestUrls;
    }

    public void setReadRequestUrls(Set<Class<ReadInterfaceRequestUrl>> readRequestUrls) {
        this.readRequestUrls = readRequestUrls;
    }

    public Set<Class<ReadInterfaces>> getReadInterfaces() {
        return readInterfaces;
    }

    public void setReadInterfaces(Set<Class<ReadInterfaces>> readInterfaces) {
        this.readInterfaces = readInterfaces;
    }

    public Set<Class<ReadInterfaceShow>> getReadShows() {
        return readShows;
    }

    public void setReadShows(Set<Class<ReadInterfaceShow>> readShows) {
        this.readShows = readShows;
    }

    public Set<Class<ReadInterfaceShowName>> getReadShowNames() {
        return readShowNames;
    }

    public void setReadShowNames(Set<Class<ReadInterfaceShowName>> readShowNames) {
        this.readShowNames = readShowNames;
    }

    public Set<Class<ReadInterfaceUnique>> getReadUniques() {
        return readUniques;
    }

    public void setReadUniques(Set<Class<ReadInterfaceUnique>> readUniques) {
        this.readUniques = readUniques;
    }

    public Set<Class<ReadInterfaceVerifyMockTag>> getReadVerifyMockTags() {
        return readVerifyMockTags;
    }

    public void setReadVerifyMockTags(Set<Class<ReadInterfaceVerifyMockTag>> readVerifyMockTags) {
        this.readVerifyMockTags = readVerifyMockTags;
    }
}
