package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.filter.*;
import cn.easyutil.easyapi.filter.operator.ReadBeanOperator;
import cn.easyutil.easyapi.filter.operator.ReadMockTemplateOperator;
import cn.easyutil.easyapi.filter.operator.ReadRequestOperator;
import cn.easyutil.easyapi.filter.operator.ReadResponseOperator;
import cn.easyutil.easyapi.javadoc.util.UncertainParamParser;
import cn.easyutil.easyapi.logic.condition.MockProcess2;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.*;

public class MethodParamsCreator {

    private Class clazz;

    private Method method;

    private ApiExtra extra;

    private ReadRequestOperator reqFilter = new ReadRequestOperator(null);

    private ReadResponseOperator resFilter = new ReadResponseOperator(null);

    private ReadBeanOperator javaBeanApiFilter = new ReadBeanOperator(null);

    private ReadMockTemplateOperator mockFilter = new ReadMockTemplateOperator(null);

    private List<DocParamEntity> requestParameters = new ArrayList<>();

    private List<DocParamEntity> returnParameter = new ArrayList<>();

    private String responseMock = "";
    private String requestMock = "";

    private JavaBeanCreator javaBeanCreator;

    public static MethodParamsCreator build(Class clazz,Method method){
        MethodParamsCreator creator = new MethodParamsCreator();
        creator.method = method;
        creator.clazz = clazz;
        return creator;
    }

    public MethodParamsCreator withClass(Class clazz){
        this.clazz = clazz;
        return this;
    }

    public MethodParamsCreator withMockFilter(ReadMockTemplateOperator mockFilter){
        this.mockFilter = mockFilter;
        return this;
    }

    public MethodParamsCreator withReqFilter(ReadRequestOperator reqFilter){
        this.reqFilter = reqFilter;
        return this;
    }

    public MethodParamsCreator withResFilter(ReadResponseOperator resFilter){
        this.resFilter = resFilter;
        return this;
    }

    public MethodParamsCreator withBeanFilter(ReadBeanOperator beanFilter){
        this.javaBeanApiFilter = beanFilter;
        return this;
    }

    public MethodParamsCreator withBeanCreator(JavaBeanCreator creator){
        this.javaBeanCreator = creator;
        return this;
    }

    public MethodParamsCreator withMethod(Method method){
        this.method = method;
        return this;
    }

    public MethodParamsCreator withExtra(ApiExtra extra){
        this.extra = extra;
        return this;
    }

    public MethodParamsCreator create(){
        try {
            extra.setParameter(null);
            extra.setModelClass(null);
            extra.setModelName(null);
            extra.setReturnType(null);
            extra.setStep(ApiCreateStep.Request);
            createParameters();
            extra.setStep(ApiCreateStep.Response);
            createReturnType();
            MockProcess2 mocker = MockProcess2.with(mockFilter);
            mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
            Object req = mocker.mockByApiParams(requestParameters);
            Object res = mocker.mockByApiParams(returnParameter);
            requestMock = ObjectUtil.isBaseObject(req)?req.toString():JsonUtil.beanToJson(req);
            responseMock = ObjectUtil.isBaseObject(res)?res.toString():JsonUtil.beanToJson(res);
            return this;
        }catch (Exception e) {
            e.printStackTrace();
            throw new ApidocException("接口参数构建失败:"+clazz.getCanonicalName()+"."+method.getName());
        }
    }

    private DocParamEntity createDoc(MethodParam param){
        Parameter parameter = param.getParameter();
        String paramName = reqFilter.parameterName(param.getParamType(),param.getParamName(),extra);
        Type paramType = reqFilter.parameterType(param.getParamType(),param.getParamName(),extra);
        Class<?> ownerClass = GenericTypeUtil.getOwnerClass(paramType);
        extra.setModelClass(ownerClass);
        extra.setParameter(parameter);
        extra.setModelName(paramName);
        if(reqFilter.ignore(paramType, ownerClass,extra)){
            return null;
        }
        if(paramType==null || ownerClass==null){
            return null;
        }
        String description = reqFilter.description(paramType, paramName,extra);
        if(StringUtil.isEmpty(description)){
            description = extra.getMethodComment().getParameter(paramName).getComment();
        }
        JavaType javaType = JavaType.getJavaTypeByType(paramType);
        //补充基本信息
        DocParamEntity entity = new DocParamEntity();
        entity.setDescription(description);
        entity.setMockTemplate(reqFilter.mockTemplate(paramType,extra));
        entity.setName(paramName);
        entity.setClassName(ownerClass.getCanonicalName());
        entity.setRequired(reqFilter.required(paramType,extra)?1:0);
        entity.setShow(reqFilter.show(paramType,extra)?1:0);
        entity.setJavaType(javaType.getType());
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(paramType);
        bind.binds(param.getBind());
        createParam(paramType, entity,bind);
        return entity;
    }

    private void deepCreateParameters(List<MethodParam> params,List<DocParamEntity> result,String originalParameterName){
        UncertainParamParser util = null;
        if(extra.getMethodComment() != null){
            util = UncertainParamParser.builder(clazz,method,extra.getControllerComment(),extra.getMethodComment());
        }
        for (MethodParam param : params) {
            DocParamEntity createParams = createDoc(param);
            if(createParams == null){
                continue;
            }
            if(CollectionUtils.isEmpty(createParams.getChildren())){
                //如果没有子属性，则把当前参数加入到参数集合中
                result.add(createParams);
                continue;
            }
            if(util!=null && originalParameterName!=null){
                for (DocParamEntity doc : createParams.getChildren()) {
                    MethodParam docParam = null;
                    if (doc.getJavaType().equals(JavaType.Map.getType()) && CollectionUtils.isEmpty(doc.getChildren())) {
                        docParam = util.parseRequestMapField(originalParameterName, doc.getName());
                    }
                    if (doc.getJavaType().equals(JavaType.Object.getType()) && CollectionUtils.isEmpty(doc.getChildren())) {
                        docParam = util.parseRequestObjField(originalParameterName, doc.getName());
                    }
                    if(docParam != null){
                        if(CollectionUtils.isEmpty(docParam.getChildren())){
                            //说明是类型转换
                            DocParamEntity doc1 = createDoc(docParam);
                            if(doc1 != null){
                                String name = doc.getName();
                                BeanUtils.copyProperties(doc1,doc);
                                doc.setName(name);
                            }
                        }else{
                            List<MethodParam> children = Optional.ofNullable(param.getChildren()).orElse(new ArrayList<>());
                            children.addAll(docParam.getChildren());
                            param.setChildren(children);
                        }
                    }
                }
                result.addAll(createParams.getChildren());
            }
            if(!CollectionUtils.isEmpty(param.getChildren())){
                //添加子类
                List<DocParamEntity> children = Optional.ofNullable(createParams.getChildren()).orElse(new ArrayList<>());
                deepCreateParameters(param.getChildren(),children,null);
                createParams.setChildren(children);
                if(originalParameterName != null){
                    //首次解析，如果是对象应该直接使用对象字段，抛弃外层包装
                    result.addAll(children);
                }else{
                    result.add(createParams);
                }
            }
        }
    }

    private List<MethodParam> createParams(Parameter parameter,Type parameterType,String parameterName){
        MethodParam param = new MethodParam();
        param.setParamType(parameterType);
        param.setParamName(parameterName);
        //获取真实类型
        Class<?> ownerClass = GenericTypeUtil.getOwnerClass(parameterType);
        UncertainParamParser util = null;
        if(extra.getMethodComment() != null){
            util = UncertainParamParser.builder(clazz,method,extra.getControllerComment(),extra.getMethodComment());
        }
        //如果是Map类型，则解析源码
        if(Map.class.isAssignableFrom(ownerClass)){
            if(util == null){
                return Collections.singletonList(param);
            }
            MethodParam mapParam = util.parseRequestMap(parameterName);
            if(mapParam == null){
                return Collections.singletonList(param);
            }
            return Optional.ofNullable(mapParam.getChildren()).orElse(Collections.emptyList());
        }
        //如果是Object类型
        if(Object.class.equals(ownerClass)){
            if(util == null){
                return Collections.singletonList(param);
            }
            MethodParam objParam = util.parseRequestObj(parameterName);
            if(objParam == null){
                return Collections.singletonList(param);
            }
            return Optional.ofNullable(objParam.getChildren()).orElse(Collections.emptyList());
        }
        //其他类型都是直接返回
        return Collections.singletonList(param);
    }

    private void createParameters(){
        Parameter[] parameters = method.getParameters();
        DefaultParameterNameDiscoverer discover = new DefaultParameterNameDiscoverer();
        // 实际方法参数形参名称
        String[] parameterNames = discover.getParameterNames(method);
        if(parameters==null || parameters.length==0){
            return ;
        }
        if(parameterNames==null || parameterNames.length==0){
            return ;
        }
        for (int i = 0; i < parameters.length; i++) {
            MethodParam param = new MethodParam();
            String parameterName = parameterNames[i];
            Type parameterType = parameters[i].getParameterizedType();
            param.setParameter(parameters[i]);
            extra.setParameter(parameters[i]);
            parameterName = reqFilter.parameterName(parameterType,parameterName,extra);
            param.setParamName(parameterName);
            parameterType = reqFilter.parameterType(parameterType,parameterName,extra);
            param.setParamType(parameterType);
            if(StringUtil.isEmpty(param.getParamName())){
                param.setParamName(parameterNames[i]);
            }
            List<DocParamEntity> result = new ArrayList<>();
            List<MethodParam> params = createParams(parameters[i], parameterType, parameterName);
            reqFilter.params(params, extra);
            deepCreateParameters(params,result,parameterNames[i]);
            this.requestParameters.addAll(result);
        }
    }

    private DocParamEntity deepCreateReturnType(MethodParam param){
        Type type = param.getParamType();
        if(type == Void.TYPE){
            return null;
        }
        extra.setReturnType(type);
        Class<?> ownerClass = GenericTypeUtil.getOwnerClass(type);
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(type);
        bind.binds(param.getBind());
        extra.setModelClass(ownerClass);
        extra.setModelName(param.getParamName());
        //获取自定义类型
        if(type==null || ownerClass==null){
            return null;
        }
        //判断是否需要忽略
        if(resFilter.ignore(type, ownerClass, bind,extra)){
            return null;
        }
        JavaType javaType = JavaType.getJavaTypeByType(type);
        DocParamEntity entity = new DocParamEntity();
        entity.setDescription(resFilter.description(type,extra));
        entity.setMockTemplate(resFilter.mockTemplate(type,extra));
        entity.setRequired(resFilter.required(type,ownerClass,bind,extra)?1:0);
        entity.setShow(resFilter.show(type,ownerClass,bind,extra)?1:0);
        entity.setName(JavaBeanCreator.nullKey);
        if(!StringUtil.isEmpty(param.getParamName())){
            entity.setName(param.getParamName());
        }
        entity.setClassName(ownerClass.getCanonicalName());
        entity.setJavaType(javaType.getType());
        createParam(type, entity,bind);
        entity.setChildren(entity.getChildren()==null?new ArrayList<>():new ArrayList<>(entity.getChildren()));
        return entity;
    }

    private List<DocParamEntity> mapOrObject(DocParamEntity doc,UncertainParamParser util,boolean isField){
        if(doc == null){
            return null;
        }
        if(util != null){
            List<MethodParam> uncertains = null;
            if (doc.getJavaType().equals(JavaType.Map.getType())) {
                MethodParam mapParam = util.parseResponseMapField(doc.getName());
                if(!isField){
                    mapParam = util.parseResponseMap();
                }
                if (mapParam!=null && mapParam.getChildren()!=null) {
                    uncertains = mapParam.getChildren();
                }
            }
            if(!StringUtil.isEmpty(doc.getClassName()) && doc.getClassName().contains("java.lang.Object")){
                MethodParam objParam = util.parseResponseObjField(doc.getName());
                if(!isField){
                    objParam = util.parseResponseObj();
                }
                if (objParam != null) {
                    uncertains = objParam.getChildren();
                }
            }
            if(uncertains != null){
                for (MethodParam uncertain : uncertains) {
                    DocParamEntity childrenDoc = createDoc(uncertain);
                    if(childrenDoc != null){
                        List<DocParamEntity> children = Optional.ofNullable(doc.getChildren()).orElse(new ArrayList<>());
                        children = new ArrayList<>(children);
                        children.add(childrenDoc);
                        return children;
                    }
                }
            }
        }
        return null;
    }

    private void deepCreateReturnType(List<MethodParam> types,List<DocParamEntity> result){
        UncertainParamParser util = null;
        if(extra.getMethodComment() != null){
            util = UncertainParamParser.builder(clazz,method,extra.getControllerComment(),extra.getMethodComment());
        }
        for (MethodParam param : types) {
            DocParamEntity document = deepCreateReturnType(param);
            if(document == null){
                continue;
            }
            List<DocParamEntity> children = Optional.ofNullable(document.getChildren()).orElse(new ArrayList<>());
            List<DocParamEntity> mapChildren = mapOrObject(document, util,false);
            if(!CollectionUtils.isEmpty(mapChildren)){
                children.addAll(mapChildren);
            }
            document.setChildren(children);
            //再处理children
            for (DocParamEntity doc : children) {
                List<DocParamEntity> docMapChildren = mapOrObject(doc, util,true);
                if(!CollectionUtils.isEmpty(docMapChildren)){
                    List<DocParamEntity> docChildren = doc.getChildren()==null?new ArrayList<>():new ArrayList<>(doc.getChildren());
                    docChildren.addAll(docMapChildren);
                    doc.setChildren(docChildren);
                }
            }
            if(!CollectionUtils.isEmpty(param.getChildren())){
                List<DocParamEntity> cr = new ArrayList<>();
                deepCreateReturnType(param.getChildren(),cr);
                children.addAll(cr);
            }
            document.setChildren(children);
            result.add(document);
        }
    }

    private void createReturnType(){
        List<MethodParam> types = resFilter.returnTypes(method, extra);
        if(types == null){
            return ;
        }
        if(types.size()==1 && !CollectionUtils.isEmpty(ProjectContext.globalParams) && !StringUtil.isEmpty(ProjectContext.globalFieldName)){
            //处理全局统一返回结构
            MethodParam param = types.get(0);
            if(!ProjectContext.globalResponseClass.equals(GenericTypeUtil.getOwnerClass(param.getParamType()))){
                param.setParamName(ProjectContext.globalFieldName);
                List<MethodParam> globalParams = ProjectContext.globalParams;
                Set<String> ignores = ProjectContext.globalResponseIgnoreFieldNames;
                ignores.add(ProjectContext.globalFieldName);
                ignores.add("serialVersionUID");
                globalParams.removeIf(next -> ignores.contains(next.getParamName()));
                globalParams.add(param);
                types = globalParams;
            }
        }
        extra.setMethod(method);
        List<DocParamEntity> result = new ArrayList<>();
        deepCreateReturnType(types,result);
        if(result.isEmpty()){
            return ;
        }
        if(result.size() == 1){
            //如果只有1条，需要判断这条是否是对象类型并且包含children，如果是，则去除第一层包装
            if(JavaType.isBaseType(result.get(0).getJavaType())){
                this.returnParameter.addAll(result);
            }else{
                this.returnParameter.addAll(result.get(0).getChildren());
            }
        }else{
            this.returnParameter.addAll(result);
        }
    }
    /**
     * 构建参数
     */
    private void createParam(Type type,DocParamEntity entity,GenericTypeBind bind){
        JavaType javaType = JavaType.getType(entity.getJavaType());
        //已经创建好的bean对象，避免无限递归循环
        Map<String, List<DocParamEntity>> exists = new HashMap<>();
        if(javaType == JavaType.Object){
            entity.setChildren(javaBeanCreator.readBean(type,bind,exists));
            return ;
        }
        Class<?> ownerClass = GenericTypeUtil.getOwnerClass(type);
        if(ownerClass == null){
            return ;
        }
        entity.setClassName(ownerClass.getCanonicalName());
        entity.setJavaType(javaType.getType());
        switch (javaType){
            case Array:{
                entity.setChildren(javaBeanCreator.readArray(type,bind));
                break;
            }
            case ArrayObject:{
                entity.setChildren(javaBeanCreator.readArrayObject(type,bind,exists));
                break;
            }
        }
        Object mockValue = mockFilter.mock(entity.getMockTemplate(), javaType);
        entity.setMockValue(JsonUtil.beanToJson(mockValue));
        String uniqueStr = extra.getControllerClass().getCanonicalName()+extra.getMethod().toGenericString()+entity.getClassName()+entity.getName();
        entity.setUnique(StringUtil.toMD5(uniqueStr));
        entity.setOrigin(EasyapiOriginUtil.createOrigin(entity));
        RenewType renewType = javaBeanApiFilter.renewType(extra.getModelClass(), bind, extra);
        entity.setRenewType(renewType==null?RenewType.increment.getType():renewType.getType());

    }


    public List<DocParamEntity> getRequestParameters() {
        return requestParameters;
    }

    public void setRequestParameters(List<DocParamEntity> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public List<DocParamEntity> getReturnParameter() {
        return returnParameter;
    }

    public void setReturnParameter(List<DocParamEntity> returnParameter) {
        this.returnParameter = returnParameter;
    }

    public String getResponseMock() {
        return responseMock;
    }

    public String getRequestMock() {
        return requestMock;
    }
}
