package cn.easyutil.easyapi.logic.condition;

import javax.validation.constraints.*;
import java.lang.annotation.Annotation;

/**
 * java内置的参数校验解析
 */
public enum ConstranionsEnums {
    //---可以解析的---
    max(Max.class){
        @Override
        public String parseToEl(Annotation annotation) {
            Max max = (Max) annotation;
            return getElThis().append("<=").append(max.value()).toString();
        }
    },
    min(Min.class){
        @Override
        public String parseToEl(Annotation annotation) {
            Min min = (Min) annotation;
            return getElThis().append(">=").append(min.value()).toString();
        }
    },
    size(Size.class){
        @Override
        public String parseToEl(Annotation annotation) {
            Size size = (Size) annotation;
            return getElThis().append(">=").append(size.min()).append("&&").append(getElThis()).append("<=").append(size.max()).toString();
        }
    },
    decimalMax(DecimalMax.class){
        @Override
        public String parseToEl(Annotation annotation) {
            DecimalMax max = (DecimalMax) annotation;
            return getElThis().append("<=").append(max.value()).toString();
        }
    },
    negative(Negative.class){
        @Override
        public String parseToEl(Annotation annotation) {
            return getElThis().append("<0").toString();
        }
    },
    negativeOrZero(NegativeOrZero.class){
        @Override
        public String parseToEl(Annotation annotation) {
            return getElThis().append("<=0").toString();
        }
    },
    notNull(NotNull.class){
        @Override
        public String parseToEl(Annotation annotation) {
            return getElThis().append("!=null").toString();
        }
    },
    notEmpty(NotEmpty.class){
        @Override
        public String parseToEl(Annotation annotation) {
            return new StringBuffer().append("@notEmpty(").append(getElThis()).append(")").toString();
        }
    },
    notBlank(NotBlank.class){
        @Override
        public String parseToEl(Annotation annotation) {
            return notEmpty.parseToEl(annotation);
        }
    },
    assertTure(AssertTrue.class){
        @Override
        public String parseToEl(Annotation annotation) {
            return getElThis().append("==true").toString();
        }
    },
    assertFalse(AssertFalse.class){
        @Override
        public String parseToEl(Annotation annotation) {
            return getElThis().append("==false").toString();
        }
    },
    pattern(Pattern.class){
        @Override
        public String parseToEl(Annotation annotation) {
            Pattern pattern = (Pattern) annotation;
            String regexp = pattern.regexp();
            return new StringBuffer()
                    .append(getElThis())
                    .append(" matches ")
                    .append("'").append(regexp).append("'").toString();
        }
    },
    digits(Digits.class),
    email(Email.class),
    future(Future.class),
    futureOrPresent(FutureOrPresent.class),
    past(Past.class),
    pastOrPresent(PastOrPresent.class),
    positive(Positive.class),
    positiveOrZero(PositiveOrZero.class),
    _null(Null.class);

    private Class annotationClass;
    ConstranionsEnums(Class annotationClass){
        this.annotationClass = annotationClass;
    }

    public static String getElString(Annotation annotation){
        if(annotation == null){
            return "";
        }
        ConstranionsEnums[] values = ConstranionsEnums.values();
        for (ConstranionsEnums value : values) {
            if(value.getAnnotationClass().isAssignableFrom(annotation.getClass())){
                return value.parseToEl(annotation);
            }
        }
        return "";
    }

    /**
     * 转换成el表达式
     * @return
     */
    public String parseToEl(Annotation annotation){
        return "";
    }

    protected StringBuffer getElThis(){
        StringBuffer sb = new StringBuffer();
        sb.append("$(current.val)");
        return sb;
    }

    public Class getAnnotationClass() {
        return annotationClass;
    }
}
