package cn.easyutil.easyapi.filter.readMock.model;

import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.filter.readMock.ReadMockTemplate;
import cn.easyutil.easyapi.logic.el.DefaultSpelMethodParser;
import cn.easyutil.easyapi.logic.el.DefaultSpelValueParser;
import cn.easyutil.easyapi.logic.el.ElExpression;
import cn.easyutil.easyapi.util.StringUtil;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class MockTemplateCommentReader implements ReadMockTemplate {
    private ElExpression elExpression;

    private static final Map<String,Object> emptyObject = new HashMap<>();

    public MockTemplateCommentReader(ElExpression elExpression){
        this.elExpression = elExpression;
    }

    public MockTemplateCommentReader(){
        this.elExpression = ElExpression.with(new DefaultSpelMethodParser(),new DefaultSpelValueParser());
    }

    @Override
    public Object mock(String template, JavaType javaType) {
        Object obj =  elExpression.getVal(template);
        switch (javaType){
            case Float:
            case Double:
                if(!(obj instanceof Double)){
                    obj = Math.random();
                }
                break;
            case Integer:
            case Long:
            case Byte:
            case Short:
                if(!(obj instanceof Number)){
                    obj = new Random().nextInt(100);
                }
                break;
            case Boolean:
                if(!(obj instanceof Boolean)){
                    obj = new Random().nextInt(1) != 0;
                }
                break;
            case String:
            case Character:
                if(!(obj instanceof String) || StringUtil.isEmpty(obj)){
                    obj = StringUtil.getRandomString(4);
                }
                break;
            case Array:{
                return Collections.emptyList();
            }
            default:
                return emptyObject;
        }
        return obj;
    }

    public ElExpression getElExpression() {
        return elExpression;
    }

    public void setElExpression(ElExpression elExpression) {
        this.elExpression = elExpression;
    }
}
