package cn.easyutil.easyapi.filter.readController.model;

import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.readController.ReadControllerShowName;
import cn.easyutil.easyapi.javadoc.reader.ClassComment;
import cn.easyutil.easyapi.util.AnnotationUtil;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.annotation.Annotation;
import java.util.Optional;

public class ControllerShowNameSwaggerReader implements ReadControllerShowName {
    @Override
    public String showName(Class controller, ApiExtra extra) {
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.Api", controller.getDeclaredAnnotations());
        if(annotation == null){
            return null;
        }
        Object value = AnnotationUtil.getAnnotationValue(annotation, "value");
        if(value!=null && !StringUtil.isEmpty(value.toString())){
            return value.toString();
        }
        Object tags = AnnotationUtil.getAnnotationValue(annotation, "tags");
        if(tags != null){
            String[] tagArray = (String[]) tags;
            if(tagArray.length > 0){
                return tagArray[0];
            }
        }
        return null;
    }
}
