package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.filter.readController.*;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.Set;

@Component
@ConfigurationProperties(prefix = "easyapi.filter.controller")
public class EasyApiFilterControllerConfiguration {

    /** 读取控制器作者*/
    private Set<Class<ReadControllerAuthor>> authors = new HashSet<>();

    /** 读取控制器说明*/
    private Set<Class<ReadControllerDescription>> descriptions = new HashSet<>();

    /** 读取控制器忽略配置*/
    private Set<Class<ReadControllerIgnore>> ignores = new HashSet<>();

    /** 读取控制器请求父路径*/
    private Set<Class<ReadControllerRequestPath>> requestPaths = new HashSet<>();

    /** 读取全部控制器*/
    private Set<Class<ReadControllers>> controllers = new HashSet<>();

    /** 读取控制器显示隐藏配置*/
    private Set<Class<ReadControllerShow>> shows = new HashSet<>();

    /** 读取控制器名称*/
    private Set<Class<ReadControllerShowName>> showNames = new HashSet<>();


    public Set<Class<ReadControllerAuthor>> getAuthors() {
        return authors;
    }

    public void setAuthors(Set<Class<ReadControllerAuthor>> authors) {
        this.authors = authors;
    }

    public Set<Class<ReadControllerDescription>> getDescriptions() {
        return descriptions;
    }

    public void setDescriptions(Set<Class<ReadControllerDescription>> descriptions) {
        this.descriptions = descriptions;
    }

    public Set<Class<ReadControllerIgnore>> getIgnores() {
        return ignores;
    }

    public void setIgnores(Set<Class<ReadControllerIgnore>> ignores) {
        this.ignores = ignores;
    }

    public Set<Class<ReadControllerRequestPath>> getRequestPaths() {
        return requestPaths;
    }

    public void setRequestPaths(Set<Class<ReadControllerRequestPath>> requestPaths) {
        this.requestPaths = requestPaths;
    }

    public Set<Class<ReadControllers>> getControllers() {
        return controllers;
    }

    public void setControllers(Set<Class<ReadControllers>> controllers) {
        this.controllers = controllers;
    }

    public Set<Class<ReadControllerShow>> getShows() {
        return shows;
    }

    public void setShows(Set<Class<ReadControllerShow>> shows) {
        this.shows = shows;
    }

    public Set<Class<ReadControllerShowName>> getShowNames() {
        return showNames;
    }

    public void setShowNames(Set<Class<ReadControllerShowName>> showNames) {
        this.showNames = showNames;
    }
}
