package cn.easyutil.easyapi.mybatis.service;

import cn.easyutil.easyapi.entity.db.auth.DBRoleProjectEntity;
import cn.easyutil.easyapi.mybatis.BaseService;
import cn.easyutil.easyapi.mybatis.MybatisUtil;
import cn.easyutil.easyapi.mybatis.mapper.RoleProjectMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

import java.util.List;

public class RoleProjectService extends BaseService<RoleProjectMapper, DBRoleProjectEntity> {
    @Override
    public RoleProjectMapper getMapper() {
        return MybatisUtil.getMapper(RoleProjectMapper.class);
    }

    public List<DBRoleProjectEntity> getByRoleId(Long roleId){
        DBRoleProjectEntity entity = new DBRoleProjectEntity();
        entity.setRoleId(roleId);
        return list(Wrappers.lambdaQuery(entity));
    }

    public void delByRoleId(Long roleId) {
        DBRoleProjectEntity entity = new DBRoleProjectEntity();
        entity.setRoleId(roleId);
        remove(Wrappers.lambdaQuery(entity));
    }
}
