package cn.easyutil.easyapi.logic.el;

import cn.easyutil.easyapi.entity.common.ElMethod;
import cn.easyutil.easyapi.entity.common.ElMethodParameter;
import cn.easyutil.easyapi.entity.common.ElMethodParameterType;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 自定义表达式中支持的常用方法
 */
public class ElDefaultMethodContext {

    @ElMethod(description = "随机获取一个中文名字",returnExample = "张三")
    public static String randomName() {
        return unames[new Random().nextInt(unames.length-1)];
    }

    @ElMethod(description = "随机获取一个公司名称",returnExample = "阿里巴巴集团")
    public static String randomCompany(){
        return hnames[new Random().nextInt(unames.length-1)];
    }

    @ElMethod(description = "随机获取一个区域",returnExample = "杭州市")
    public static String randomArea(){
        return anames[new Random().nextInt(unames.length-1)];
    }

    @ElMethod(description = "随机获取一个手机号码",returnExample = "18888888888")
    public static String randomMobile(){
        return "138"+StringUtil.getRandomString(8,"1234567890");
    }

    @ElMethod(description = "随机获取一张网络图片地址",returnExample = "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/2721a0fb957b4949a2c4ef3505e70d97.jpg")
    public static String randomImg(){
        return null;
    }

    @ElMethod(description = "随机获取一个网络视频地址",returnExample = "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/c74c5c50a7d04d559584867810afd327.mp4")
    public static String randomVod(){
        return null;
    }

    @ElMethod(description = "依据逗号将参数分隔，并随机获取一个",returnExample = "李四",parameters =
            @ElMethodParameter(name = "str",type = ElMethodParameterType.String,example = "张三,李四,王五")
    )
    public static String randomEnumString(String str){
        List<String> list = Stream.of(str.split(",")).filter(s -> !StringUtil.isEmpty(s)).collect(Collectors.toList());
        return list.get(new Random().nextInt(list.size()-1));
    }

    @ElMethod(description = "依据逗号将参数分隔，并随机获取一个转换成数字",returnExample = "30",parameters =
            @ElMethodParameter(name = "str",type = ElMethodParameterType.String,example = "10,20,30")
    )
    public static Double randomEnumNumer(String str){
        List<String> list = Stream.of(str.split(",")).filter(s -> !StringUtil.isEmpty(s)).collect(Collectors.toList());
        return Double.valueOf(list.get(new Random().nextInt(list.size()-1)));
    }

    @ElMethod(description = "获取当前时间戳",returnExample = "1609430400000")
    public static Long time(){
        return System.currentTimeMillis();
    }

    @ElMethod(description = "获取当前时间的字符串形式",returnExample = "2021-01-01 00:00:00")
    public static String timeStr(){
        return timeStr("yyyy-MM-dd HH:mm:ss");
    }

    @ElMethod(description = "依据转换形式转换当前时间",returnExample = "2021-01-01 00:00:00",parameters =
            @ElMethodParameter(name = "pattern",type = ElMethodParameterType.String,example = "yyyy-MM-dd HH:mm:ss")
    )
    public static String timeStr(String pattern){
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(System.currentTimeMillis());
    }

    @ElMethod(description = "随机获取整数值",returnExample = "5",
            parameters = {
                    @ElMethodParameter(name = "start", type = ElMethodParameterType.Number, example = "0"),
                    @ElMethodParameter(name = "end", type = ElMethodParameterType.Number, example = "10")
            }
    )
    public static Integer randomNumer(int start, int end) {
        Random random = new Random();
        while (true) {
            int i = random.nextInt(end);
            if (i >= start) {
                return i;
            }
        }
    }

    @ElMethod(description = "随机获取整数值",returnExample = "5",
            parameters = @ElMethodParameter(name = "end", type = ElMethodParameterType.Number, example = "10")
    )
    public static Integer randomNumer(int end) {
        return randomNumer(0, end);
    }

    @ElMethod(description = "随机获取整数值",returnExample = "1")
    public static Integer randomNumer() {
        return randomNumer(1);
    }

    //----------------以下字符串处理--------------------------
    @ElMethod(description = "按条件切割字符串",returnExample = "[\"浙江\",\"杭州\"]",parameters = {
            @ElMethodParameter(name = "str",type = ElMethodParameterType.String,example = "浙江:杭州"),
            @ElMethodParameter(name = "splitChar",type = ElMethodParameterType.String,example = ":")
    })
    public static String[] split(String str,String splitChar){
        if(isEmpty(str)){
            return new String[]{};
        }
        return str.split(splitChar);
    }

    @ElMethod(description = "返回字符串是否为空",returnExample = "false",parameters = {
            @ElMethodParameter(name = "str",type = ElMethodParameterType.String,example = "api"),
    })
    public static boolean isEmpty(String str){
        return str==null || str.length()==0;
    }

    @ElMethod(description = "转换为字符串",returnExample = "api",parameters = {
            @ElMethodParameter(name = "obj",type = ElMethodParameterType.Object,example = "api"),
    })
    public static String toStr(Object obj){
        if(obj == null){
            return "";
        }
        return obj.toString();
    }


    //----------------以下是加密----------------------------------











    public static Object getElVal(Map<String, Object> source, String key) {
        if (source == null) {
            return null;
        }
        List<String> collect = Stream.of(key.split("\\.")).filter(k -> !StringUtil.isEmpty(k)).collect(Collectors.toList());
        if (collect.size() == 0) {
            return source.get(key);
        }
        Object val = source;
        for (String s : collect) {
            val = JsonUtil.beanToMap(val);
            String skey = s;
            if (s.contains("[") && s.endsWith("]")) {
                skey = s.substring(0, s.indexOf("["));
            }
            val = ((Map) val).get(skey);
            if (s.contains("[") && s.endsWith("]")) {
                String num = s.substring(s.indexOf("[") + 1, s.indexOf("]"));
                if (val instanceof List) {
                    val = ((List) val).get(Integer.parseInt(num));
                } else if (val.getClass().isArray()) {
                    val = Array.get(val, Integer.parseInt(num));
                }
            }
        }
        return val;
    }




    /** 人名*/
    private static final String[] unames = new String[]{
            "石榴",
            "华安",
            "如花",
            "伯虎",
            "旺财",
            "莲花",
            "八两金"
    };

    /** 公司名*/
    private static final String[] hnames = new String[]{
            "杭州驿飞科技有限公司",
            "浙江阿里巴巴集团",
            "深圳腾讯集团",
            "万达企业",
            "开心麻花影视",
            "杭州嘉年华房地产",
            "美国苹果集团"
    };

    /** 中文内容*/
    private static final String[] tnames = new String[]{
            "流行蝴蝶剑",
            "LOL之提莫队长",
            "王者荣耀元哥教学",
            "java-从入门到删库",
            "韭菜鸡蛋有大用处",
            "盘点你不知道的陈老师",
            "锄禾日当午，汗滴禾下土"
    };

    /** 地区名*/
    private static final String[] anames = new String[]{
            "浙江杭州",
            "苏州",
            "美国加利福尼亚州",
            "创伟科技园",
            "江苏",
            "西安",
            "滨江区"
    };

    /** 图片地址*/
    private static final String[] purl = new String[]{
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/2721a0fb957b4949a2c4ef3505e70d97.jpg",
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/eaf80ccb4e754f6fada1af42ea737248.jpg",
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/778b813fc28048f6848ec7aadc691a13.jpg",
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/3ac939b7dc9e422abf4fa981edfb8ca5.jpg",
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/104e6044c738429f8679e5bb88e665e4.jpg",
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/39addca3d1794be69b57d8ec86dd622b.jpg",
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/b6f009df8ff7452e9ae9a96d7312f573.jpg"
    };

    /** 视频地址*/
    private static final String[] vurl = new String[]{
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/c74c5c50a7d04d559584867810afd327.mp4",
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/3316bf5183bc414982731088f9daf550.mp4",
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/184355b287144a54b9c0e9bf265f5b08.mp4",
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/1566619e084f4e4b863ca22ffb072c3d.mp4",
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/6fbea57381e14afcb5c3aafc85ed7eda.mp4",
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/8688586e408f44499c3b7bb30b641579.mp4",
            "https://ssyerv1.oss-cn-hangzhou.aliyuncs.com/picture/c969b347bd634e97b7a262a446a3f09f.mp4"
    };
}
