package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.operator.ReadBeanOperator;
import cn.easyutil.easyapi.filter.operator.ReadMockTemplateOperator;
import cn.easyutil.easyapi.javadoc.reader.FieldComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.*;
import java.util.stream.Collectors;

public class JavaBeanCreator {
    /**
     * 没有key的参数默认key
     */
    public static final String nullKey = "_null";

    private ReadBeanOperator filter;

    private ReadMockTemplateOperator mockFilter;
    //项目根目录
    private Set<String> projectBasePaths;

    private ApiExtra extra;

    public static JavaBeanCreator builder(ReadBeanOperator filter, Set<String> projectBasePaths,ReadMockTemplateOperator mockFilter,ApiExtra extra){
        JavaBeanCreator creator = new JavaBeanCreator(filter,projectBasePaths,mockFilter,extra);
        return creator;
    }

    public JavaBeanCreator(ReadBeanOperator filter, Set<String> projectBasePaths,ReadMockTemplateOperator mockFilter,ApiExtra extra){
        this.filter = filter;
        this.projectBasePaths = projectBasePaths;
        this.mockFilter = mockFilter;
        this.extra = extra;
    }

    private String buildCreatersKey(Class aClass,GenericTypeBind bind){
        String bindKey = "";
        if(bind.keys().size() > 0){
            for (String key : bind.keys()) {
                bindKey += bind.get(key);
            }
        }
        return aClass.getCanonicalName()+bindKey;
    }

    public List<DocParamEntity> readBean(Type type, GenericTypeBind binds, Map<String,List<DocParamEntity>> exists){
        Class aClass;
        if(binds == null){
            binds = new GenericTypeBind();
        }
        aClass = GenericTypeUtil.getOwnerClass(type);
        GenericTypeBind currentBinds = GenericTypeUtil.getGenericTypes(type);
        binds.binds(currentBinds);
        if (aClass==Object.class || aClass == Class.class) {
            return Collections.emptyList();
        }
        String creatersKey = buildCreatersKey(aClass, currentBinds);
        if(exists.containsKey(creatersKey)){
            return JsonUtil.jsonToList(JsonUtil.beanToJson(exists.get(creatersKey)),DocParamEntity.class);
        }
        exists.put(creatersKey,Collections.emptyList());
        List<DocParamEntity> bean = new ArrayList<>();
        JavaType javaType = JavaType.getJavaTypeByType(type);
        switch (javaType){
            case Object:
                bean = getBean(aClass, binds,exists);
                break;
            case ArrayObject:
                bean = readArrayObject(type, binds,exists);
                break;
            case Array:
                bean = readArray(type, binds);
                break;
        }
        //先放一个占位
        exists.put(creatersKey,bean);
        return bean;
    }

    public List<DocParamEntity> readArray(Type type,GenericTypeBind binds){
        if(binds == null){
            binds = new GenericTypeBind();
        }
        //获取集合中的真实泛型类型
        Type arrayType = GenericTypeUtil.getOwnerClass(type);
        if(GenericTypeUtil.isGeneric(type)){
            GenericTypeBind genericTypeBind = GenericTypeUtil.getGenericTypes(type);
            Type bindType = binds.matchVariable(genericTypeBind.get(0).getTypeName());
            if(bindType != null){
                arrayType = bindType;
            }else{
                arrayType = genericTypeBind.get(0);
            }
        }
        //基本数据类型
        DocParamEntity childrean = new DocParamEntity();
        childrean.setRequired(0);
        childrean.setShow(0);
        RenewType renewType = filter.renewType(extra.getModelClass(), binds, extra);
        childrean.setRenewType(renewType==null?RenewType.increment.getType():renewType.getType());
        childrean.setJavaType(JavaType.getJavaTypeByType(arrayType).getType());
        childrean.setClassName(type.getTypeName());
        childrean.setName(nullKey);
        Object mockValue = mockFilter.mock(childrean.getMockTemplate(), JavaType.getType(childrean.getJavaType()));
        childrean.setMockValue(ObjectUtil.isBaseObject(mockValue)?mockValue.toString():JsonUtil.beanToJson(mockValue));
        childrean.setOrigin(EasyapiOriginUtil.createOrigin(childrean));
        return Collections.singletonList(childrean);
    }

    public List<DocParamEntity> readArrayObject(Type type, GenericTypeBind binds, Map<String,List<DocParamEntity>> exists){
        if(binds == null){
            binds = new GenericTypeBind();
        }
        //获取集合中的真实泛型类型
        Type arrayType = GenericTypeUtil.getOwnerClass(type);
        if(GenericTypeUtil.isGeneric(type)){
            if(Collection.class.isAssignableFrom(GenericTypeUtil.getOwnerClass(arrayType))){
                arrayType = binds.get(0);
            }
        }
        if(arrayType instanceof Class && Collection.class.isAssignableFrom(GenericTypeUtil.getOwnerClass(arrayType))){
            arrayType = Map.class;
        }
        //非集合类型
        return readBean(arrayType, binds,exists);
    }

    private List<DocParamEntity> getBean(Class<?> beanClass,GenericTypeBind binds,Map<String,List<DocParamEntity>> exists){
        extra.setModelField(null);
        extra.setFieldComment(null);
        extra.setModelClass(null);
        extra.setModelComment(null);
        String modelName = extra.getModelName();
        List<DocParamEntity> result = new ArrayList<>();
        //需要读取父类
        Class<?> clazz = beanClass;
        //存放所有子类及父类的字段
        Set<String> fieldNames = new HashSet<>();
        while (clazz!=null && !clazz.equals(Object.class) && clazz!=Class.class) {
            extra.setModelClass(clazz);
            extra.setModelName(modelName);
            //先读取源码字段注释
            File beanFile = null;
            for (String projectBasePath : this.projectBasePaths) {
                beanFile = CreatorCommonMethod.getClassFile(clazz, projectBasePath);
                if(beanFile.exists()){
                    break;
                }
            }
            JavaSourceReader classFileReader = new JavaSourceReader();
            if(beanFile!=null && beanFile.exists()){
                classFileReader = JavaSourceReader.builder(beanFile);
            }
            extra.setModelComment(classFileReader.getComment());
            List<FieldComment> fieldComments = classFileReader.getComment().getFields();
            Map<String, FieldComment> fieldComment = fieldComments.stream().collect(Collectors.toMap(JavaSourceComment::getName, item -> item));
            List<FieldParam> params = filter.params(clazz, binds, extra);
            if(params == null){
                clazz = clazz.getSuperclass();
                continue;
            }
            for (FieldParam param : params) {
                extra.setModelClass(clazz);
                extra.setModelComment(classFileReader.getComment());
                extra.setModelName(param.getParamName());
                Field field = param.getField();
                Type type = param.getParamType();
                String paramName = param.getParamName();
                extra.setModelField(field);
                if(StringUtil.isEmpty(paramName)){
                    continue;
                }
                if(field != null){
                    extra.setFieldComment(Optional.ofNullable(fieldComment.get(field.getName())).orElse(new FieldComment()));
                }
                //如果该字段标记忽略，则不解析
                if (filter.ignore(type,binds,extra)) {
                    continue;
                }
                int size = fieldNames.size();
                fieldNames.add(paramName);
                if (size == fieldNames.size()) {
                    //父类不覆盖子类，子类最大
                    continue;
                }
                //字段类型
                Class<?> ownerClass = GenericTypeUtil.getOwnerClass(type);
                if(GenericTypeUtil.isGeneric(type) && !GenericTypeUtil.isArray(type)){
                    Type bindType = binds.matchVariable(type.getTypeName());
                    if(bindType != null){
                        type = bindType;
                        ownerClass = GenericTypeUtil.getOwnerClass(type);
                    }
                }
                GenericTypeBind currentBinds = GenericTypeUtil.getGenericTypes(type);
                if(type==null || ownerClass==null){
                    continue;
                }
                for (String key : currentBinds.keys()) {
                    Type matchType = binds.matchVariable(currentBinds.get(key).getTypeName());
                    if(matchType != null){
                        currentBinds.bind(key,matchType);
                    }
                }
                if(currentBinds.size() == 0){
                    currentBinds.binds(binds);
                }
                //读取字段说明
                String description = filter.description(type,binds,extra);
                if (StringUtil.isEmpty(description)) {
                    //注释不存在则使用属性名
                    description = paramName;
                }
                if (!GenericTypeUtil.isArray(type) && ownerClass == Class.class) {
                    ownerClass = Map.class;
                    type = Map.class;
                }

                JavaType javaType = filter.javaType(type,binds,extra);
                if(javaType == null){
                    continue;
                }
                //组装参数
                DocParamEntity entity = new DocParamEntity();
                entity.setName(paramName);
                entity.setClassName(ownerClass.getCanonicalName());
                entity.setDescription(description);
                entity.setJavaType(javaType.getType());
                entity.setMockTemplate(filter.mockTemplate(type, binds,extra));
                entity.setShow(filter.show(type, binds,extra)?1:0);
                entity.setRequired(filter.required(type, binds,extra)?1:0);
                entity.setConditionTemplate(String.join(",", filter.conditions(type, binds, extra)));
                switch (javaType) {
                    case Object:
                    case ArrayObject:
                    case Array:
                        entity.setChildren(readBean(type,currentBinds,exists));
                        break;
                    default:
                        Object mockValue = mockFilter.mock(entity.getMockTemplate(), javaType);
                        entity.setMockValue(ObjectUtil.isBaseObject(mockValue)?mockValue.toString():JsonUtil.beanToJson(mockValue));
                }
                entity.setUnique(field==null?UUID.randomUUID().toString():StringUtil.toMD5(field.toGenericString()));
                RenewType renewType = filter.renewType(type, binds,extra);
                entity.setRenewType(renewType==null?RenewType.increment.getType():renewType.getType());
                entity.setOrigin(EasyapiOriginUtil.createOrigin(entity));
                result.add(entity);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }
}
