package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.operator.ReadControllerOperator;
import cn.easyutil.easyapi.util.StringUtil;

public class ControllerCreator {

    private Class clazz;

    private DBModuleControllerEntity controllerBean;

    //拦截器
    private ReadControllerOperator filter = new ReadControllerOperator(null);

    //控制器名称
    private ApiExtra extra;

    private ControllerCreator(){}

    public static ControllerCreator builder(Class clazz){
        ControllerCreator creator = new ControllerCreator();
        creator.clazz = clazz;
        return creator;
    }

    public ControllerCreator setFilter(ReadControllerOperator filter){
        if(filter == null){
            return this;
        }
        this.filter = filter;
        return this;
    }

    public ControllerCreator setExtra(ApiExtra extra){
        this.extra = extra;
        return this;
    }

    public DBModuleControllerEntity buildController(){
        if(controllerBean != null){
            return controllerBean;
        }
        try {
            create();
        }catch (Exception e){
            throw new ApidocException("创建controller:"+clazz.getCanonicalName()+"失败,原因:"+e.getMessage());
        }
        return controllerBean;
    }

    private void create() {
        controllerBean = new DBModuleControllerEntity();
        controllerBean.setShowName(filter.showName(clazz,extra));
        if(StringUtil.isEmpty(controllerBean.getShowName())){
            controllerBean.setShowName(clazz.getSimpleName());
        }
        controllerBean.setShowName(controllerBean.getShowName().trim());
        controllerBean.setShow(filter.show(clazz,extra)?1:0);
        controllerBean.setApiPath(filter.requestPath(clazz,extra));
        controllerBean.setClassName(clazz.getCanonicalName());
        controllerBean.setPinyin(StringUtil.toPinYin(controllerBean.getShowName()).trim());
        controllerBean.setDescription(filter.description(clazz,extra));
        controllerBean.setAuthor(filter.author(clazz,extra));
        controllerBean.setSource(extra.getControllerComment().getSource());
        controllerBean.setSearchTags(DBModuleControllerEntity.buildSearchTag(controllerBean).trim());
    }
}
