package cn.easyutil.easyapi.javadoc.util;

public enum MapGetMethodsPreEnum {

    base(".get(", null),
    String1(".getString(", String.class),
    String2(".getStr(", String.class),
    Integer1(".getInteger(", Integer.class),
    Integer2(".getIntValue(", Integer.class),
    Integer3(".getInt(", Integer.class),
    Long1(".getLong(", Long.class),
    Long2(".getLongValue(", Long.class),
    Boolean1(".getBoolean(", Boolean.class),
    Boolean2(".getBooleanValue(", Boolean.class),
    Boolean3(".getBool(", Boolean.class),
    Double1(".getBigDecimal(", Double.class),
    Double2(".getDouble(", Double.class),
    Double3(".getDoubleValue(", Double.class),
    Float1(".getFloat(", Float.class),
    Float2(".getFloatValue(", Float.class),
    Object1(".getObject(", null),
    Object2(".getOrDefault(", null),
    Object3(".getObj(", null),
    Object4(".getBean(", null),

    ;
    private String keyword;
    private Class<?> clazz;

    MapGetMethodsPreEnum(java.lang.String keyword, Class<?> clazz) {
        this.keyword = keyword;
        this.clazz = clazz;
    }

    public static MapGetMethodsPreEnum hasKeyword(String pre,String post,String str){
        if(pre == null) pre = "";
        if(post == null) post = "";
        if(str == null) str = "";
        for (MapGetMethodsPreEnum value : MapGetMethodsPreEnum.values()) {
            String keyword = pre+value.getKeyword()+post;
            if(str.toUpperCase().contains(keyword.toUpperCase())){
                return value;
            }
        }
        return null;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Class<?> getClazz() {
        return clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }
}
