package cn.easyutil.easyapi.javadoc.util;

import java.util.List;

public class CommentStringUtil {

    public static boolean isAssignLine(String paramName,String line){
        if(!line.contains("=") || !line.contains(paramName) || !line.contains(";")){
            //没有赋值操作或没有出现参数，不处理
            return false;
        }
        return isVariableLine(paramName,line);
    }

    public static boolean isVariableLine(String variable,String line){
        String search = line;
        while (search.contains(variable)){
            int pre = search.indexOf(variable)-1;
            int post = search.indexOf(variable)+variable.length();
            boolean checkPre = true;
            boolean checkPost = true;
            if(pre <= 0){
                checkPre = false;
            }
            if(post >= search.length()){
                checkPost = false;
            }
            if(checkPre){
                char c = search.charAt(pre);
                if((c>='a' && c<='z') || c=='.'){
                    //说明不是单纯的参数
                    search = search.replaceFirst(variable,"");
                    continue;
                }
            }
            if(checkPost){
                char c = search.charAt(post);
                if((c>='a' && c<='z') || c=='.'){
                    //说明不是单纯的参数
                    search = search.replaceFirst(variable,"");
                    continue;
                }
            }
            return true;
        }
        return false;
    }

    /**
     * 根据源码字符串，获取赋值的类名和变量名
     * @param str   源码串
     */
    public static MapKeyVal<String> getAssign(String str){
        if(str == null) str = "";
        if(str.contains("=")){
            str = str.substring(0,str.indexOf("="));
        }
        if(str.contains("<") && str.contains(">")){
            //去除泛型
            String pre = str.substring(0,str.indexOf("<"));
            String post = str.substring(str.lastIndexOf(">")+1);
            str = pre+post;
        }
        str = str.replace(";","");
        String[] split = str.replace("final", "").trim().split(" ");
        if(split.length == 1){
            return MapKeyVal.builder(split[0],split[0]);
        }
        return MapKeyVal.builder(split[0],split[1]);
    }

    public static String getReturnVariable(List<String> sources){
        for (String line : sources) {
            if(!line.contains(" return ")){
                continue;
            }
            String returnName = line.replace("return", "").replace(" ", "").replace(";", "");
            if(!returnName.equals("null")){
                return returnName;
            }
        }
        return null;
    }

    /**
     * 过滤字符串
     * @param pre   需要丢弃的前缀
     * @param post  需要丢弃的后缀
     * @param str   字符串
     * @param filter    过滤器
     */
    public static String keywordFilter(String pre,String post,String str,KeywordFilter...filter){
        if(pre == null) pre = "";
        if(str == null) str = "";
        if(post == null) post = "";
        if(str.contains(pre)){
            str = str.substring(str.indexOf(pre)+pre.length());
        }
        if(str.contains(post)){
            str = str.substring(0,str.indexOf(post));
        }
        for (KeywordFilter keywordFilter : filter) {
            return keywordFilter.filter(str.trim());
        }
        return str;
    }

    public static String getMapGetMethodKey(MapGetMethodsPreEnum preEnum,String str){
        if(preEnum == null){
            return null;
        }
        if(str == null) str = "";
        String keyword = preEnum.getKeyword();
        if(!str.contains(keyword)){
            return null;
        }
        return keywordFilter(keyword,")",str,(s)->{
            if(s.contains(".")){
                return s.substring(0,s.indexOf(".")).replace("\"","");
            }
            return s.replace("\"","");
        });
    }

    public interface KeywordFilter{
        String filter(String str);
    }
}
