//package cn.easyutil.easyapi.interview.controller;
//
//import cn.easyutil.easyapi.content.ProjectContext;
//import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
//import cn.easyutil.easyapi.entity.common.AccessAuth;
//import cn.easyutil.easyapi.entity.common.ApidocComment;
//import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
//import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
//import cn.easyutil.easyapi.entity.db.doc.*;
//import cn.easyutil.easyapi.entity.db.unit.DBComplexTestEntity;
//import cn.easyutil.easyapi.entity.db.unit.DBComplexTestInfoEntity;
//import cn.easyutil.easyapi.exception.ApidocException;
//import cn.easyutil.easyapi.interview.dto.*;
//import cn.easyutil.easyapi.interview.entity.HttpEntity;
//import cn.easyutil.easyapi.interview.session.CurrentSession;
//import cn.easyutil.easyapi.interview.vo.InterfaceInfoVo;
//import cn.easyutil.easyapi.interview.vo.StartTestVo;
//import cn.easyutil.easyapi.logic.el.ApiEvaluationContext;
//import cn.easyutil.easyapi.logic.el.DefaultSpelMethodParser;
//import cn.easyutil.easyapi.logic.el.DefaultSpelValueParser;
//import cn.easyutil.easyapi.logic.el.ElExpression;
//import cn.easyutil.easyapi.logic.unit.ComplexTestProcess;
//import cn.easyutil.easyapi.logic.unit.UnitTestProcesser;
//import cn.easyutil.easyapi.service.*;
//import cn.easyutil.easyapi.util.AssertUtil;
//import cn.easyutil.easyapi.util.JsonUtil;
//import cn.easyutil.easyapi.util.StringUtil;
//import cn.easyutil.easyapi.util.http.*;
//import org.springframework.beans.BeanUtils;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
//import org.springframework.web.bind.annotation.PostMapping;
//import org.springframework.web.bind.annotation.RequestBody;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RestController;
//
//import javax.annotation.Resource;
//import java.util.*;
//import java.util.stream.Collectors;
//
//@RestController
//@ConditionalOnMissingBean(name = "easyapiComplexApidocController")
//@RequestMapping("/easyapi/doc/complex")
//public class ComplexApidocController {
//
//    @Resource(name = "easyapiInterfaceService")
//    private InterfaceService interfaceService;
//
//    @Resource(name = "easyapiModuleService")
//    private ModuleService moduleService;
//
//    @Resource(name = "easyapiControllerService")
//    private ControllerService controllerService;
//
//    @Resource(name = "easyapiInterfaceParamService")
//    private InterfaceParamService parameterService;
//
//    @Resource(name = "easyapiUserService")
//    private UserService userService;
//
//    @Resource(name = "easyapiProjectService")
//    private ProjectService projectService;
//
//    @Resource(name = "easyapiInterfaceParamService")
//    private InterfaceParamService interfaceParamService;
//
//    @ApidocComment("获取el表达式结果")
//    @PostMapping("/validation")
//    @AccessAuth(code = 1000)
//    public Object validation(String template, ApiEvaluationContext context){
//        DefaultSpelValueParser parser = new DefaultSpelValueParser();
//        parser.setContext(context);
//        return ElExpression.with(parser, DefaultSpelMethodParser.get()).getVal(template);
//    }
//
//    @ApidocComment("网络请求")
//    @PostMapping("/doUrl")
//    @AccessAuth(code = 1000)
//    public HttpRes doUrl(@RequestBody HttpEntity entity){
//        HttpRes httpRes = ComplexTestProcess.doUrl(entity, true);
//        httpRes.getResponseMsg();
//        return httpRes;
//    }
//
//    @ApidocComment("执行测试")
//    @PostMapping("/startTest")
//    @AccessAuth(code = 1000)
//    public StartTestVo startTest(@RequestBody StartTestDto dto){
//        AssertUtil.isNull(dto.getGroups(), "分组不能为空");
//        AssertUtil.isEmpty(dto.getUrl(), "请求地址不能为空");
//        AssertUtil.isTrue(dto.getGroups().isEmpty(), "分组不能为空");
//        AssertUtil.isNull(dto.getInterfaceId(), "接口id不能为空");
//        //用户id
//        Long userId = CurrentSession.getCurrentUser().getId();
//        DBModuleInterfaceEntity interfaceEntity = interfaceService.getById(dto.getInterfaceId());
//        AssertUtil.isNull(interfaceEntity, "接口不存在");
//
//        //封装请求参数
//        HttpEntity enty = new HttpEntity();
//        enty.setUrl(dto.getUrl());
//        enty.setMethod(interfaceEntity.getRequestMethodString());
//        enty.setBodyType(interfaceEntity.getBodyType());
//
//        //总线程数量
//        List<HttpEntity> processers = new ArrayList<>();
//        List<GroupExtendsDto> groups = dto.getGroups();
//        for (GroupExtendsDto group : groups) {
//            //获取线程数量
//            if(group.getThreadCount()==null || group.getThreadCount()<=0){
//                continue;
//            }
//            for (int i = 0; i < group.getThreadCount(); i++) {
//                HttpEntity cp = new HttpEntity();
//                BeanUtils.copyProperties(enty, cp);
//                cp.setJsonHeaders(group.getRequestHeaders());
//                cp.setJsonParams(group.getRequestParam());
//                processers.add(cp);
//            }
//        }
//        if(processers.size() == 0){
//            throw new ApidocException("线程数为0");
//        }
//        //包装接口返回
//        StartTestVo vo = new StartTestVo();
//
//        //测试信息
//        DBComplexTestEntity result = new DBComplexTestEntity();
//        result.setSuccessCount(0);
//        result.setFailCount(0);
//        vo.setTest(result);
//        result.setUserId(userId);
//        Long startTime = System.currentTimeMillis();
//        //测试后的结果
//        List<UnitTestProcesser> unitTestProcessers = ComplexTestProcess.startTest(processers,null,true);
//        Long endTime = System.currentTimeMillis();
//        result.setTimeConsuming(endTime - startTime);
//        result.setInterfaceId(interfaceEntity.getId());
//        result.setSuccessKey(dto.getSuccessKey());
//        result.setSuccessOper(dto.getSuccessOper());
//        result.setSuccessVal(dto.getSuccessVal());
//        result.setGroupIds(groups.stream().filter(item -> item.getId()!=null).map(item -> item.getId().toString()).collect(Collectors.joining(",")));
//        if(unitTestProcessers.size() == 0){
//            return vo;
//        }
//
//        //每一个测试的详情信息
//        List<DBComplexTestInfoEntity> infos = new ArrayList<>();
//        for (UnitTestProcesser processer : unitTestProcessers) {
//            DBComplexTestInfoEntity entity = ComplexTestProcess.buildInfo(processer.getHttpRes(),processer.getDecodes(), dto.getSuccessKey(), dto.getSuccessOper(), dto.getSuccessVal());
//            entity.setRequestHeaders(processer.getEnty().getJsonHeaders());
//            entity.setRequestParam(processer.getEnty().getJsonParams());
//            //TODO
//            entity.setTestId(null);
//            infos.add(entity);
//        }
//
//        result.setSuccessCount((int)infos.stream().filter(item->item.getSuccessStatus()==1).count());
//        result.setFailCount(infos.size() - result.getSuccessCount());
//        vo.setInfos(infos);
//        return vo;
//    }
//
//    @ApidocComment("将本地项目模块下发到对方机器")
//    @PostMapping("/syncPull")
//    @AccessAuth(code = 1000)
//    public ReciveSourceDto syncPull(@RequestBody SyncRemoteAllDto dto){
//        DBProjectEntity project = syncCheckProject(dto,dto.getTargetProjectName());
//        DBModuleEntity module = syncCheckModule(project.getId(), dto.getTargetModuleName());
//        DBUserEntity user = userService.getByAccount(dto.getTargetUsername());
//        AssertUtil.isNull(user, "用户名或密码错误");
//        AssertUtil.isTrue(!user.getPassword().equals(dto.getTargetPassword()), "用户名或密码错误");
//        ReciveSourceDto reciveSourceDto = syncBuild(module.getId());
//        BeanUtils.copyProperties(dto, reciveSourceDto);
//        return reciveSourceDto;
//    }
//
//    @ApidocComment("将项目同步到远程机器")
//    @PostMapping("/syncRemoteAll")
//    @AccessAuth(code = 1000)
//    public void syncRemoteAll(@RequestBody SyncRemoteAllDto dto){
//        DBProjectEntity project = syncCheckProject(dto,dto.getLocalProjectName());
//        DBModuleEntity module = syncCheckModule(project.getId(), dto.getLocalModuleName());
//        ReciveSourceDto reciveSourceDto = syncBuild(module.getId());
//        BeanUtils.copyProperties(dto, reciveSourceDto);
//        //先验证用户名密码是否正确
//        HttpRes login = doEasyapiUrl(dto.getTargetHost() + "/easyapi/doc/user/login", JsonUtil.beanToJson(dto));
//        getDoEasyapiUrlResult(login);
//        HttpRes sync = doEasyapiUrl(dto.getTargetHost() + "/easyapi/doc/complex/reciveSource", JsonUtil.beanToJson(reciveSourceDto));
//        getDoEasyapiUrlResult(sync);
//    }
//
//    @ApidocComment("接收远程来的同步")
//    @PostMapping("/reciveSource")
//    @AccessAuth(code = 1000)
//    public void reciveSource(@RequestBody ReciveSourceDto dto){
//        String username = dto.getTargetUsername();
//        String password = dto.getTargetPassword();
//        String projectName = dto.getTargetProjectName();
//        String moduleName = dto.getTargetModuleName();
//        AssertUtil.isTrue(StringUtil.isEmpty(username),"用户名或密码错误");
//        AssertUtil.isTrue(StringUtil.isEmpty(password),"用户名或密码错误");
//        DBUserEntity user = userService.getByAccount(username);
//        AssertUtil.isNull(user, "用户名或密码错误");
//        AssertUtil.isTrue(!user.getPassword().equals(password), "用户名或密码错误");
//        saveSyncSource(projectName,moduleName,dto.getSources(),dto.getOverwriteType());
//    }
//
//    /**
//     * 处理controller的同步
//     * @param controller
//     * @param currentController
//     * @param overwriteType
//     */
//    private DBModuleControllerEntity syncController(DBModuleControllerEntity controller,DBModuleControllerEntity currentController,int overwriteType ){
//        switch (overwriteType){
//            case 0 :{
//                //全量覆盖
//                if(currentController != null){
//                    controller.setId(currentController.getId());
//                    controllerService.update(controller);
//                }else{
//                    controllerService.insert(controller);
//                }
//                break;
//            }
//            case 1 :{
//                //增量
//                if(currentController == null){
//                    controllerService.insert(controller);
//                }
//                break;
//            }
//            case 2 :{
//                //替换
//                if(currentController != null){
//                    controller.setId(currentController.getId());
//                    controllerService.update(controller);
//                }
//                break;
//            }
//        }
//        return controller;
//    }
//
//    /**
//     * 处理接口同步
//     * @param in
//     * @param currentInterface
//     * @param params
//     * @param overwriteType
//     * @return
//     */
//    private DBModuleInterfaceEntity syncInterface(DBModuleInterfaceEntity in,DBModuleInterfaceEntity currentInterface,DBInterfaceParamEntity params,int overwriteType){
//        switch (overwriteType){
//            case 0 :{
//                //全量覆盖
//                if(in != null){
//                    in.setId(currentInterface.getId());
//                    interfaceService.update(in);
//                }else{
//                    interfaceService.insert(in);
//                }
//                interfaceParamService.delete(EasyapiBindSQLExecuter.build(new DBInterfaceParamEntity()).eq(DBInterfaceParamEntity::getInterfaceId, in.getId()));
//                params.setInterfaceId(in.getId());
//                interfaceParamService.insert(params);
//                break;
//            }
//            case 1 :{
//                //增量
//                if(currentInterface == null){
//                    interfaceService.insert(in);
//                    params.setInterfaceId(in.getId());
//                    interfaceParamService.insert(params);
//                }
//                break;
//            }
//            case 2 :{
//                //替换
//                if(currentInterface != null){
//                    in.setId(currentInterface.getId());
//                    interfaceService.update(in);
//                    interfaceParamService.delete(EasyapiBindSQLExecuter.build(new DBInterfaceParamEntity()).eq(DBInterfaceParamEntity::getInterfaceId, in.getId()));
//                    params.setInterfaceId(in.getId());
//                    interfaceParamService.insert(params);
//                }
//                break;
//            }
//        }
//        return in;
//    }
//
//    public HttpRes doEasyapiUrl(String url,String param){
//        HttpOperation operation = HttpUtilFactory.fastCreate(url, HttpMethod.POST);
//        operation.getHttpReq().addParam(param);
//        operation.getHttpReq().addHeader("Content-Type","application/json");
//        HttpRes httpRes = operation.doUrl();
//        if(httpRes.getResponseCode() != 200){
//            throw new ApidocException("请求远程机器失败");
//        }
//        String responseMsg = httpRes.getResponseMsg();
//        if(StringUtil.isEmpty(responseMsg)){
//            throw new ApidocException("请求远程机器失败");
//        }
//        Map<String, Object> map = JsonUtil.jsonToMap(responseMsg);
//        if(!map.get("code").equals(200)){
//            throw new ApidocException("目标机器返回:"+map.get("remark"));
//        }
//        return httpRes;
//    }
//
//    private DBProjectEntity syncCheckProject(SyncRemoteAllDto dto,String projectName){
//        AssertUtil.isEmpty(dto.getTargetHost(), "未知的目标机器");
//        AssertUtil.isEmpty(dto.getTargetProjectName(), "未知的目标项目");
//        AssertUtil.isEmpty(dto.getTargetModuleName(), "未知的目标模块");
//        AssertUtil.isEmpty(dto.getTargetUsername(), "目标机器登陆名不能为空");
//        AssertUtil.isEmpty(dto.getTargetPassword(), "目标机器登陆密码不能为空");
//        AssertUtil.isEmpty(dto.getLocalProjectName(), "未知的本地项目");
//        AssertUtil.isEmpty(dto.getLocalModuleName(), "未知的本地模块");
//
//        DBProjectEntity project = projectService.getByName(projectName);
//        AssertUtil.isNull(project, "未知的本地项目");
//        return project;
//    }
//
//    private DBModuleEntity syncCheckModule(Long projectId,String moduleName){
//        DBModuleEntity module = moduleService.get(EasyapiBindSQLExecuter.build(new DBModuleEntity())
//                .eq(DBModuleEntity::getProjectId, projectId)
//                .eq(DBModuleEntity::getName, moduleName)
//        );
//        AssertUtil.isNull(module, "未知的本地模块");
//        return module;
//    }
//
//    private ReciveSourceDto syncBuild(Long moduleId){
//        //查询对应的controller和接口
//        List<DBModuleControllerEntity> controllers = controllerService.list(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity()).eq(DBModuleControllerEntity::getModuleId, moduleId));
//        if(StringUtil.isEmpty(controllers)){
//            throw new ApidocException("该模块下没有接口");
//        }
//        //发起同步
//        List<SyncSourceDto> sources = new ArrayList<>();
//        for (DBModuleControllerEntity controller : controllers) {
//            SyncSourceDto source = new SyncSourceDto();
//            source.setController(controller);
//            List<InterfaceInfoVo> ins = new ArrayList<>();
//            source.setInterfaces(ins);
//            List<DBModuleInterfaceEntity> list = interfaceService.list(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity()).eq(DBModuleInterfaceEntity::getControllerId, controller.getId()));
//            if(list == null){
//                continue;
//            }
//            for (DBModuleInterfaceEntity in : list) {
//                InterfaceInfoVo vo = new InterfaceInfoVo();
//                vo.setInfo(in);
//                DBInterfaceParamEntity paramEntity = parameterService.get(EasyapiBindSQLExecuter.build(new DBInterfaceParamEntity()).eq(DBInterfaceParamEntity::getInterfaceId, in.getId()));
//                vo.setParams(paramEntity);
//                ins.add(vo);
//            }
//            sources.add(source);
//        }
//
//        //一次性发给目标机器
//        ReciveSourceDto reciveSourceDto = new ReciveSourceDto();
//        reciveSourceDto.setSources(sources);
//        return reciveSourceDto;
//    }
//
//    public String getDoEasyapiUrlResult(HttpRes result){
//        if(result.getResponseCode()!=200 || StringUtil.isEmpty(result.getResponseMsg())){
//            throw new ApidocException("远程机器连接失败");
//        }
//        Map<String, Object> doResult = JsonUtil.jsonToMap(result.getResponseMsg());
//        if(!doResult.get("code").equals(200)){
//            throw new ApidocException(doResult.get("remark").toString());
//        }
//        return doResult.get("data").toString();
//    }
//
//    /**
//     * 保存远程来的同步数据
//     * @param projectName
//     * @param moduleName
//     * @param sources
//     * @param overwriteType
//     */
//    public void saveSyncSource(String projectName,String moduleName,List<SyncSourceDto> sources,int overwriteType){
//        //查看用户权限
//        DBProjectEntity project = projectService.getByName(projectName);
//        DBModuleEntity module = null;
//        if(project != null){
//            module = moduleService.get(EasyapiBindSQLExecuter.build(new DBModuleEntity()).eq(DBModuleEntity::getProjectId, project.getId()).eq(DBModuleEntity::getName, moduleName));
//        }
//
//        //如果项目不存在并且要求只替换，则直接返回
//        if(overwriteType==2 && project==null){
//            return ;
//        }
//
//        if(project == null){
//            //生成新的项目和模块
//            DBProjectEntity entity = new DBProjectEntity();
//            entity.setDefaultStatus(0);
//            entity.setDescription("远程同步项目");
//            entity.setDisable(0);
//            entity.setName(projectName);
//            entity.setTitle(projectName);
//            projectService.insert(entity);
//            project = entity;
//
//            DBModuleEntity mo = new DBModuleEntity();
//            mo.setProjectId(project.getId());
//            mo.setName(moduleName);
//            mo.setDescription("远程同步模块");
//            mo.setDefaultStatus(0);
//            mo.setOutPackgeStatus(0);
//            moduleService.insert(mo);
//            module = mo;
//        }
//
//        if(overwriteType == 0){
//            //全量覆盖的话，先删除现有的全部数据
//            moduleService.clearById(module.getId());
//        }
//
//        //开始解决同步问题
//        for (SyncSourceDto source : sources) {
//            DBModuleControllerEntity controller = source.getController();
//            controller.setProjectId(project.getId());
//            controller.setModuleId(module.getId());
//            controller.setId(null);
//            String className = controller.getClassName();
//            DBModuleControllerEntity currentController = controllerService.get(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity())
//                    .eq(DBModuleControllerEntity::getProjectId, project.getId())
//                    .eq(DBModuleControllerEntity::getModuleId, module.getId())
//                    .eq(DBModuleControllerEntity::getClassName, className)
//            );
//            //同步后的controller
//            DBModuleControllerEntity resultController = syncController(controller,currentController,overwriteType);
//
//            List<InterfaceInfoVo> interfaces = source.getInterfaces();
//            if(interfaces == null){
//                continue;
//            }
//            for (InterfaceInfoVo infoVo : interfaces) {
//                DBModuleInterfaceEntity info = infoVo.getInfo();
//                DBInterfaceParamEntity params = infoVo.getParams();
//                info.setId(null);
//                info.setProjectId(resultController.getProjectId());
//                info.setModuleId(resultController.getModuleId());
//                info.setControllerId(resultController.getId());
//                String requestUrl = info.getRequestUrl();
//
//                DBModuleInterfaceEntity currentInterface = interfaceService.get(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity())
//                        .eq(DBModuleInterfaceEntity::getControllerId, resultController.getId())
//                        .eq(DBModuleInterfaceEntity::getRequestUrl, requestUrl)
//                );
//
//                syncInterface(info,currentInterface,params, overwriteType);
//            }
//        }
//    }
//}
