package cn.easyutil.easyapi.filter.readInterface.model;

import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceIgnore;
import cn.easyutil.easyapi.util.AnnotationUtil;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class InterfaceIgnoreSwaggerReader implements ReadInterfaceIgnore {
    @Override
    public Boolean ignore(Method method, ApiExtra extra) {
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiOperation", method.getAnnotations());
        if(annotation != null){
            Object hidden = AnnotationUtil.getAnnotationValue(annotation, "hidden");
            if(hidden != null){
                return (Boolean) hidden;
            }
        }
        return null;
    }
}
