package cn.easyutil.easyapi.filter.readController.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.readController.ReadControllerAuthor;
import cn.easyutil.easyapi.javadoc.reader.CommentDetail;
import cn.easyutil.easyapi.util.ObjectUtil;

import java.util.List;
import java.util.Map;

public class ControllerAuthorApiReader implements ReadControllerAuthor {
    @Override
    public String author(Class controller, ApiExtra extra) {
        Map<String, ApidocComment> classAnnotation = ObjectUtil.getClassAnnotation(controller, ApidocComment.class);
        if(classAnnotation.isEmpty()){
            return null;
        }
        ApidocComment next = classAnnotation.entrySet().iterator().next().getValue();
        return next.author();
    }
}
