package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.util.StringUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.apache.commons.codec.Charsets;
import org.apache.ibatis.type.JdbcType;

import java.sql.Blob;

/**
 * 接口参数
 */
@TableName("EASYAPI_INTERFACE_PARAM")
public class DBInterfaceParamEntity extends BaseDbEntity {

    @DDL(value = "INTERFACE_ID",ddl="`INTERFACE_ID` bigint(20) DEFAULT NULL COMMENT '接口id'")
    @ApidocComment("接口id")
    private Long interfaceId;

    @DDL(value = "REQUEST_PARAM_REMARK",ddl = "`REQUEST_PARAM_REMARK` varchar(255) DEFAULT NULL COMMENT '请求参数说明'")
    @ApidocComment("请求参数说明")
    private String requestParamRemark;

    @DDL(value = "RESPONSE_PARAM_REMARK",ddl = "`RESPONSE_PARAM_REMARK` varchar(255) DEFAULT NULL COMMENT '响应参数说明'")
    @ApidocComment("响应参数说明")
    private String responseParamRemark;

    @TableField(exist = false)
    private String requestParamJson;

    @DDL(value = "REQUEST_PARAM_JSON_BYTES",type = Blob.class,ddl = "`REQUEST_PARAM_JSON_BYTES` BLOB DEFAULT NULL COMMENT '请求参数详情json'")
    @ApidocComment("请求参数详情json")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] requestParamJsonBytes;

    @TableField(exist = false)
    private String responseParamJson;

    @DDL(value = "RESPONSE_PARAM_JSON_BYTES",type = Blob.class,ddl = "`RESPONSE_PARAM_JSON_BYTES` BLOB DEFAULT NULL COMMENT '响应参数详情json'")
    @ApidocComment("响应参数详情json")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] responseParamJsonBytes;

    @TableField(exist = false)
    private String responseMock;

    @DDL(value = "RESPONSE_MOCK_BYTES",type = Blob.class,ddl = "`RESPONSE_MOCK_BYTES` BLOB DEFAULT NULL COMMENT '响应结果mock'")
    @ApidocComment("接口mock")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] responseMockBytes;

    @TableField(exist = false)
    private String requestMock;

    @DDL(value = "REQUEST_MOCK_BYTES",type = Blob.class,ddl = "`REQUEST_MOCK_BYTES` BLOB DEFAULT NULL COMMENT '请求参数mock'")
    @ApidocComment("接口mock")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] requestMockBytes;

    public Long getInterfaceId() {
        return interfaceId;
    }

    public void setInterfaceId(Long interfaceId) {
        this.interfaceId = interfaceId;
    }

    public String getRequestParamRemark() {
        return requestParamRemark;
    }

    public void setRequestParamRemark(String requestParamRemark) {
        this.requestParamRemark = requestParamRemark;
    }

    public String getResponseParamRemark() {
        return responseParamRemark;
    }

    public void setResponseParamRemark(String responseParamRemark) {
        this.responseParamRemark = responseParamRemark;
    }

    public String getRequestParamJson() {
        return requestParamJson;
    }

    public void setRequestParamJson(String requestParamJson) {
        this.requestParamJson = requestParamJson;
        this.requestParamJsonBytes = StringUtil.isEmpty(requestParamJson)?null:requestParamJson.getBytes(Charsets.UTF_8);
    }

    public byte[] getRequestParamJsonBytes() {
        return requestParamJsonBytes;
    }

    public void setRequestParamJsonBytes(byte[] requestParamJsonBytes) {
        this.requestParamJsonBytes = requestParamJsonBytes;
        this.requestParamJson = requestParamJsonBytes==null?null:new String(requestParamJsonBytes,Charsets.UTF_8);
    }

    public String getResponseParamJson() {
        return responseParamJson;
    }

    public void setResponseParamJson(String responseParamJson) {
        this.responseParamJson = responseParamJson;
        this.responseParamJsonBytes = StringUtil.isEmpty(responseParamJson)?null:responseParamJson.getBytes(Charsets.UTF_8);
    }

    public byte[] getResponseParamJsonBytes() {
        return responseParamJsonBytes;
    }

    public void setResponseParamJsonBytes(byte[] responseParamJsonBytes) {
        this.responseParamJsonBytes = responseParamJsonBytes;
        this.responseParamJson = responseParamJsonBytes==null?null:new String(responseParamJsonBytes,Charsets.UTF_8);
    }

    public String getResponseMock() {
        return responseMock;
    }

    public void setResponseMock(String responseMock) {
        this.responseMock = responseMock;
        this.responseMockBytes = StringUtil.isEmpty(responseMock)?null:responseMock.getBytes(Charsets.UTF_8);
    }

    public byte[] getResponseMockBytes() {
        return responseMockBytes;
    }

    public void setResponseMockBytes(byte[] responseMockBytes) {
        this.responseMockBytes = responseMockBytes;
        this.responseMock = responseMockBytes==null?null:new String(responseMockBytes,Charsets.UTF_8);
    }

    public String getRequestMock() {
        return requestMock;
    }

    public void setRequestMock(String requestMock) {
        this.requestMock = requestMock;
        this.requestMockBytes = StringUtil.isEmpty(requestMock)?null:requestMock.getBytes(Charsets.UTF_8);
    }

    public byte[] getRequestMockBytes() {
        return requestMockBytes;
    }

    public void setRequestMockBytes(byte[] requestMockBytes) {
        this.requestMockBytes = requestMockBytes;
        this.requestMock = requestMockBytes==null?null:new String(requestMockBytes,Charsets.UTF_8);
    }
}
