package cn.easyutil.easyapi.entity.db.auth;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import com.baomidou.mybatisplus.annotation.TableName;

/**
 * 角色对应的权限
 */
@TableName("EASYAPI_ROLE_AUTH")
public class DBRoleAuthEntity extends BaseDbEntity {

    @DDL(value = "MODULE_ID",ddl="`MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id'")
    @ApidocComment("模块id")
    private Long moduleId;

    @DDL(value = "ROLE_ID",ddl = "`ROLE_ID` bigint(20) DEFAULT NULL COMMENT '角色id'")
    @ApidocComment("角色id")
    private Long roleId;

    @DDL(value = "AUTH_CODE",ddl = "`AUTH_CODE` int(10) DEFAULT NULL COMMENT '可访问的接口编码'")
    @ApidocComment("可访问的接口编码")
    private Integer authCode;

    public Long getModuleId() {
        return moduleId;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public Integer getAuthCode() {
        return authCode;
    }

    public void setAuthCode(Integer authCode) {
        this.authCode = authCode;
    }
}
