package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.filter.readBean.*;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.Set;

@Component
@ConfigurationProperties(prefix = "easyapi.filter.bean")
public class EasyApiFilterBeanConfiguration {

    /** 读取参数断言表达式*/
    private Set<Class<ReadBeanCondition>> conditions = new HashSet<>();

    /** 读取参数说明*/
    private Set<Class<ReadBeanDescription>> descriptors = new HashSet<>();

    /** 读取参数忽略配置*/
    private Set<Class<ReadBeanIgnore>> ignore = new HashSet<>();

    /** 读取参数类型*/
    private Set<Class<ReadBeanJavaType>> javaTypes = new HashSet<>();

    /** 读取参数mock模板*/
    private Set<Class<ReadBeanMockTemplate>> mockTemplates = new HashSet<>();

    /** 读取参数名称*/
    private Set<Class<ReadBeanName>> names = new HashSet<>();

    /** 读取全部参数*/
    private Set<Class<ReadBeanParams>> params = new HashSet<>();

    /** 读取参数更新策略*/
    private Set<Class<ReadBeanRenewType>> renewTypes = new HashSet<>();

    /** 读取参数必填配置*/
    private Set<Class<ReadBeanRequired>> required = new HashSet<>();

    /** 读取参数显示隐藏配置*/
    private Set<Class<ReadBeanShow>> show = new HashSet<>();

    /** 读取参数类型*/
    private Set<Class<ReadBeanType>> type = new HashSet<>();

    public Set<Class<ReadBeanCondition>> getConditions() {
        return conditions;
    }

    public void setConditions(Set<Class<ReadBeanCondition>> conditions) {
        this.conditions = conditions;
    }

    public Set<Class<ReadBeanDescription>> getDescriptors() {
        return descriptors;
    }

    public void setDescriptors(Set<Class<ReadBeanDescription>> descriptors) {
        this.descriptors = descriptors;
    }

    public Set<Class<ReadBeanIgnore>> getIgnore() {
        return ignore;
    }

    public void setIgnore(Set<Class<ReadBeanIgnore>> ignore) {
        this.ignore = ignore;
    }

    public Set<Class<ReadBeanJavaType>> getJavaTypes() {
        return javaTypes;
    }

    public void setJavaTypes(Set<Class<ReadBeanJavaType>> javaTypes) {
        this.javaTypes = javaTypes;
    }

    public Set<Class<ReadBeanMockTemplate>> getMockTemplates() {
        return mockTemplates;
    }

    public void setMockTemplates(Set<Class<ReadBeanMockTemplate>> mockTemplates) {
        this.mockTemplates = mockTemplates;
    }

    public Set<Class<ReadBeanName>> getNames() {
        return names;
    }

    public void setNames(Set<Class<ReadBeanName>> names) {
        this.names = names;
    }

    public Set<Class<ReadBeanParams>> getParams() {
        return params;
    }

    public void setParams(Set<Class<ReadBeanParams>> params) {
        this.params = params;
    }

    public Set<Class<ReadBeanRenewType>> getRenewTypes() {
        return renewTypes;
    }

    public void setRenewTypes(Set<Class<ReadBeanRenewType>> renewTypes) {
        this.renewTypes = renewTypes;
    }

    public Set<Class<ReadBeanRequired>> getRequired() {
        return required;
    }

    public void setRequired(Set<Class<ReadBeanRequired>> required) {
        this.required = required;
    }

    public Set<Class<ReadBeanShow>> getShow() {
        return show;
    }

    public void setShow(Set<Class<ReadBeanShow>> show) {
        this.show = show;
    }

    public Set<Class<ReadBeanType>> getType() {
        return type;
    }

    public void setType(Set<Class<ReadBeanType>> type) {
        this.type = type;
    }
}
