package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.filter.config.*;
import cn.easyutil.easyapi.util.ObjectUtil;

/**
 * 全部配置文件
 */
public class AllConfiguration {

    private EasyApiBaseConfiguration configuration;
    private EasyApiDataConfiguration dataConfiguration;
    private EasyApiUserConfiguration userConfiguration;
    private ReadControllerConfig readControllerConfig;
    private ReadInterfaceConfig readInterfaceConfig;
    private ReadBeanConfig readBeanConfig;
    private ReadMockTemplateConfig readMockTemplateConfig;
    private ReadRequestConfig readRequestConfig;
    private ReadResponseConfig readResponseConfig;

    public EasyApiBaseConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(EasyApiBaseConfiguration configuration) {
        this.configuration = configuration;
    }

    public EasyApiDataConfiguration getDataConfiguration() {
        return dataConfiguration;
    }

    public void setDataConfiguration(EasyApiDataConfiguration dataConfiguration) {
        this.dataConfiguration = dataConfiguration;
    }

    public EasyApiUserConfiguration getUserConfiguration() {
        return userConfiguration;
    }

    public void setUserConfiguration(EasyApiUserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
    }

    public ReadControllerConfig getReadControllerConfig() {
        return readControllerConfig;
    }

    public void setReadControllerConfig(ReadControllerConfig readControllerConfig) {
        this.readControllerConfig = readControllerConfig;
    }


    public void setReadControllerConfig(EasyApiFilterControllerConfiguration controllerConfig){
        if(controllerConfig == null){
            return ;
        }
        if(this.readControllerConfig == null){
            this.readControllerConfig = new ReadControllerConfig();
        }
        controllerConfig.getControllers().forEach(item -> this.readControllerConfig.addReadControllerFilter(ObjectUtil.newInstance(item)));
        controllerConfig.getAuthors().forEach(item -> this.readControllerConfig.addReadAuthorFilter(ObjectUtil.newInstance(item)));
        controllerConfig.getDescriptions().forEach(item -> this.readControllerConfig.addReadDescriptionFilter(ObjectUtil.newInstance(item)));
        controllerConfig.getIgnores().forEach(item -> this.readControllerConfig.addReadIgnoreFilter(ObjectUtil.newInstance(item)));
        controllerConfig.getRequestPaths().forEach(item -> this.readControllerConfig.addReadRequestPathFilter(ObjectUtil.newInstance(item)));
        controllerConfig.getShowNames().forEach(item -> this.readControllerConfig.addReadShowNameFilter(ObjectUtil.newInstance(item)));
        controllerConfig.getShows().forEach(item -> this.readControllerConfig.addReadShowFilter(ObjectUtil.newInstance(item)));
    }

    public ReadInterfaceConfig getReadInterfaceConfig() {
        return readInterfaceConfig;
    }

    public void setReadInterfaceConfig(ReadInterfaceConfig readInterfaceConfig) {
        this.readInterfaceConfig = readInterfaceConfig;
    }

    public void setReadInterfaceConfig(EasyApiFilterInterfaceConfiguration interfaceConfig){
        if(interfaceConfig == null){
            return ;
        }
        if(this.readInterfaceConfig == null){
            this.readInterfaceConfig = new ReadInterfaceConfig();
        }
        interfaceConfig.getReadBodyTypes().forEach(item -> this.readInterfaceConfig.addReadBodyTypeFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadCustomSearch().forEach(item -> this.readInterfaceConfig.addReadCustomSearchFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadDescription().forEach(item -> this.readInterfaceConfig.addReadDescriptionFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadIgnore().forEach(item -> this.readInterfaceConfig.addReadIgnoreFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadInterfaces().forEach(item -> this.readInterfaceConfig.addReadInterfacesFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadRenewTypes().forEach(item -> this.readInterfaceConfig.addReadRenewTypesFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadReqPackages().forEach(item -> this.readInterfaceConfig.addReadReqPackagesFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadRequestMethods().forEach(item -> this.readInterfaceConfig.addReadRequestMethodsFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadRequestUrls().forEach(item -> this.readInterfaceConfig.addReadRequestUrlsFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadResPackages().forEach(item -> this.readInterfaceConfig.addReadResPackagesFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadShowNames().forEach(item -> this.readInterfaceConfig.addReadShowNamesFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadShows().forEach(item -> this.readInterfaceConfig.addReadShowsFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadUniques().forEach(item -> this.readInterfaceConfig.addReadUniquesFilter(ObjectUtil.newInstance(item)));
        interfaceConfig.getReadVerifyMockTags().forEach(item -> this.readInterfaceConfig.addReadVerifyMockTagsFilter(ObjectUtil.newInstance(item)));
    }


    public ReadMockTemplateConfig getReadMockTemplateConfig() {
        return readMockTemplateConfig;
    }

    public void setReadMockTemplateConfig(ReadMockTemplateConfig readMockTemplateConfig) {
        this.readMockTemplateConfig = readMockTemplateConfig;
    }

    public void setReadMockTemplateConfig(EasyApiFilterMockConfiguration mockTemplateConfig){
        if(mockTemplateConfig == null){
            return ;
        }
        if(this.readMockTemplateConfig == null){
            this.readMockTemplateConfig = new ReadMockTemplateConfig();
        }
        mockTemplateConfig.getMockTemplates().forEach(item -> this.readMockTemplateConfig.addReadMockTemplatesFilter(ObjectUtil.newInstance(item)));
    }


    public ReadRequestConfig getReadRequestConfig() {
        return readRequestConfig;
    }

    public void setReadRequestConfig(ReadRequestConfig readRequestConfig) {
        this.readRequestConfig = readRequestConfig;
    }

    public void setReadRequestConfig(EasyApiFilterRequestConfiguration readRequestConfig){
        if(readRequestConfig == null){
            return ;
        }
        if(this.readRequestConfig == null){
            this.readRequestConfig = new ReadRequestConfig();
        }
        readRequestConfig.getRequired().forEach(item -> this.readRequestConfig.addReadRequiredFilter(ObjectUtil.newInstance(item)));
        readRequestConfig.getConditions().forEach(item -> this.readRequestConfig.addReadConditionsFilter(ObjectUtil.newInstance(item)));
        readRequestConfig.getDescriptions().forEach(item -> this.readRequestConfig.addReadDescriptionsFilter(ObjectUtil.newInstance(item)));
        readRequestConfig.getIgnore().forEach(item -> this.readRequestConfig.addReadIgnoreFilter(ObjectUtil.newInstance(item)));
        readRequestConfig.getMockTemplate().forEach(item -> this.readRequestConfig.addReadMockTemplateFilter(ObjectUtil.newInstance(item)));
        readRequestConfig.getName().forEach(item -> this.readRequestConfig.addReadNameFilter(ObjectUtil.newInstance(item)));
        readRequestConfig.getParams().forEach(item -> this.readRequestConfig.addReadParamsFilter(ObjectUtil.newInstance(item)));
        readRequestConfig.getShow().forEach(item -> this.readRequestConfig.addReadShowFilter(ObjectUtil.newInstance(item)));
        readRequestConfig.getType().forEach(item -> this.readRequestConfig.addReadTypeFilter(ObjectUtil.newInstance(item)));
    }

    public ReadResponseConfig getReadResponseConfig() {
        return readResponseConfig;
    }

    public void setReadResponseConfig(ReadResponseConfig readResponseConfig) {
        this.readResponseConfig = readResponseConfig;
    }

    public void setReadResponseConfig(EasyApiFilterResponseConfiguration responseConfig){
        if(responseConfig == null){
            return ;
        }
        if(this.readResponseConfig == null){
            this.readResponseConfig = new ReadResponseConfig();
        }
        responseConfig.getRequired().forEach(item -> this.readResponseConfig.addReadRequiredFilter(ObjectUtil.newInstance(item)));
        responseConfig.getDescriptions().forEach(item -> this.readResponseConfig.addReadDescriptionsFilter(ObjectUtil.newInstance(item)));
        responseConfig.getIgnore().forEach(item -> this.readResponseConfig.addReadIgnoreFilter(ObjectUtil.newInstance(item)));
        responseConfig.getMockTemplate().forEach(item -> this.readResponseConfig.addReadMockTemplateFilter(ObjectUtil.newInstance(item)));
        responseConfig.getReturnTypes().forEach(item -> this.readResponseConfig.addReadRetrunTypesFilter(ObjectUtil.newInstance(item)));
        responseConfig.getShow().forEach(item -> this.readResponseConfig.addReadShowFilter(ObjectUtil.newInstance(item)));
    }

    public ReadBeanConfig getReadBeanConfig() {
        return readBeanConfig;
    }

    public void setReadBeanConfig(ReadBeanConfig readBeanConfig) {
        this.readBeanConfig = readBeanConfig;
    }

    public void setReadBeanConfig(EasyApiFilterBeanConfiguration beanConfig){
        if(beanConfig == null){
            return ;
        }
        if(this.readBeanConfig == null){
            this.readBeanConfig = new ReadBeanConfig();
        }
        beanConfig.getRequired().forEach(item -> this.readBeanConfig.addReadRequiredFilter(ObjectUtil.newInstance(item)));
        beanConfig.getConditions().forEach(item -> this.readBeanConfig.addReadConditionsFilter(ObjectUtil.newInstance(item)));
        beanConfig.getDescriptors().forEach(item -> this.readBeanConfig.addReadDescriptorsFilter(ObjectUtil.newInstance(item)));
        beanConfig.getIgnore().forEach(item -> this.readBeanConfig.addReadIgnoreFilter(ObjectUtil.newInstance(item)));
        beanConfig.getJavaTypes().forEach(item -> this.readBeanConfig.addReadJavaTypesFilter(ObjectUtil.newInstance(item)));
        beanConfig.getMockTemplates().forEach(item -> this.readBeanConfig.addReadMockTemplatesFilter(ObjectUtil.newInstance(item)));
        beanConfig.getNames().forEach(item -> this.readBeanConfig.addReadNamesFilter(ObjectUtil.newInstance(item)));
        beanConfig.getParams().forEach(item -> this.readBeanConfig.addReadParamsFilter(ObjectUtil.newInstance(item)));
        beanConfig.getRenewTypes().forEach(item -> this.readBeanConfig.addReadRenewTypesFilter(ObjectUtil.newInstance(item)));
        beanConfig.getShow().forEach(item -> this.readBeanConfig.addReadShowFilter(ObjectUtil.newInstance(item)));
        beanConfig.getType().forEach(item -> this.readBeanConfig.addReadTypeFilter(ObjectUtil.newInstance(item)));
    }
}
