package cn.easyutil.easyapi.util.http;

import cn.easyutil.easyapi.util.IOUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;

import java.io.InputStream;
import java.util.Map;

/**
 * http请求的响应结果
 */
public class HttpRes {

    //响应状态码
    private Integer responseCode;

    //响应内容
    private InputStream responseInputStream;

    //响应头
    private Map<String,String> responseHeaders;

    //响应内容
    private String responseMsg;

    //响应结果的base64串，方便之后转byte或下载使用
    private String responseBase64;


    public String getResponseMsg(){
        if(responseMsg != null){
            return responseMsg;
        }
        byte[] bytes = IOUtil.inputToByte(this.responseInputStream);
        responseMsg =  new String(bytes);
        this.setResponseBase64(StringUtil.base64Encode(bytes));
        return  responseMsg;
    }

    public <T>T getResponseMsg(Class<T> tClass){
        getResponseMsg();
        return JsonUtil.jsonToBean(this.responseMsg, tClass);
    }

    public Integer getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    public Map<String, String> getResponseHeaders() {
        return responseHeaders;
    }

    public void setResponseHeaders(Map<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public InputStream getResponseInputStream() {
        return responseInputStream;
    }

    public void setResponseInputStream(InputStream responseInputStream) {
        this.responseInputStream = responseInputStream;
    }

    public String getResponseBase64() {
        return responseBase64;
    }

    public void setResponseBase64(String responseBase64) {
        this.responseBase64 = responseBase64;
    }
}
