package cn.easyutil.easyapi.mybatis.service;

import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserTemporaryAuthEntity;
import cn.easyutil.easyapi.mybatis.BaseService;
import cn.easyutil.easyapi.mybatis.MybatisUtil;
import cn.easyutil.easyapi.mybatis.mapper.UserTemporaryAuthMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

import java.util.ArrayList;
import java.util.List;

public class UserTemporaryAuthService extends BaseService<UserTemporaryAuthMapper, DBUserTemporaryAuthEntity> {
    @Override
    public UserTemporaryAuthMapper getMapper() {
        return MybatisUtil.getMapper(UserTemporaryAuthMapper.class);
    }

    public void delByUserId(Long userId){
        DBUserTemporaryAuthEntity entity = new DBUserTemporaryAuthEntity();
        entity.setUserId(userId);
        remove(Wrappers.lambdaQuery(entity));
    }

    public void binds(DBUserEntity user, List<String> codes){
        List<DBUserTemporaryAuthEntity> list = new ArrayList<>();
        for (String code : codes) {
            DBUserTemporaryAuthEntity entity = new DBUserTemporaryAuthEntity();
            entity.setUserId(user.getId());
            entity.setAuthCode(code);
            list.add(entity);
        }
        saveBatch(list);
    }
}
