package cn.easyutil.easyapi.mybatis.service;

import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.mybatis.BaseService;
import cn.easyutil.easyapi.mybatis.MybatisUtil;
import cn.easyutil.easyapi.mybatis.mapper.UserMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

public class UserService extends BaseService<UserMapper, DBUserEntity> {

    @Override
    public UserMapper getMapper() {
        return MybatisUtil.getMapper(UserMapper.class);
    }

    public DBUserEntity getByAccount(String account){
        DBUserEntity entity = new DBUserEntity();
        entity.setAccount(account);
        return getOne(Wrappers.lambdaQuery(entity),false);
    }
}
