package cn.easyutil.easyapi.mybatis;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import org.apache.ibatis.logging.nologging.NoLoggingImpl;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;

import javax.sql.DataSource;

public class MybatisUtil {

    private static SqlSessionManager sqlSessionManager = null;

    public synchronized static <T> void init(DataSource dataSource, Class<?>...mappers) {
        if (sqlSessionManager == null) {
            MybatisSqlSessionFactoryBean mfb = new MybatisSqlSessionFactoryBean();
            mfb.setDataSource(dataSource);
            MybatisConfiguration conf = new MybatisConfiguration();
            conf.setMapUnderscoreToCamelCase(true);
            for (Class<?> mapper : mappers) {
                conf.addMapper(mapper);
            }
            Environment env = new Environment.Builder("datasource").dataSource(dataSource).transactionFactory(new JdbcTransactionFactory()).build();
            conf.setEnvironment(env);
            conf.setLogImpl(NoLoggingImpl.class);
            mfb.setConfiguration(conf);
            conf.addMapper(SqlExecMapper.class);
            MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
            interceptor.addInnerInterceptor(new PaginationInnerInterceptor(DbType.H2));
            mfb.setPlugins(interceptor);
            try {
                sqlSessionManager = SqlSessionManager.newInstance(mfb.getObject());
            } catch (Exception e) {
                sqlSessionManager = null;
            }
        }
    }

    public static <T> T getMapper(Class<T> clazz) {
        return sqlSessionManager.getMapper(clazz);
    }
}
