package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.logic.condition.ConstranionsEnums;
import cn.easyutil.easyapi.util.AnnotationUtil;
import cn.easyutil.easyapi.util.StringUtil;

import javax.validation.Constraint;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 构建文档时的常用方法
 */
public class CreatorCommonMethod {

    public static List<String> readConditons(Annotation[] annotations){
        if(annotations==null || annotations.length==0){
            return Collections.emptyList();
        }
        List<String> conditons = new ArrayList<>();
        for (Annotation annotation : annotations) {
            if(annotation instanceof ApidocComment){
                ApidocComment an = (ApidocComment) annotation;
                String[] conditions = an.conditions();
                if(conditions.length == 0){
                    return conditons;
                }
                return Arrays.asList(conditions);
            }
            if(AnnotationUtil.isAssignableFromAnnotation(annotation, Constraint.class)){
                conditons.add(ConstranionsEnums.getElString(annotation));
            }
        }
        return conditons;
    }

    public static String mockTemplate(Annotation[] annotations){
        if(annotations==null || annotations.length==0){
            return "";
        }
        for (Annotation annotation : annotations) {
            if(annotation instanceof ApidocComment){
                ApidocComment api = (ApidocComment) annotation;
                return api.mockValue();
            }
        }
        Annotation an = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiModelProperty", annotations);
        if(an != null){
            Object example = AnnotationUtil.getAnnotationValue(an, "example");
            if(!StringUtil.isEmpty(example)){
                return example.toString();
            }
        }
        return "";
    }

    public static File getClassFile(Class clazz,String projectBasePath){
        String path = clazz.getCanonicalName().replace(".", File.separator) + ".java";
        return new File(projectBasePath + path);
    }
}
