package cn.easyutil.easyapi.logic.condition;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConditionUtil {

    /**
     * 校验数据类型是否和文档一致
     * @param params
     * @param checkVal
     * @return
     */
    public static ConditionResult alike(Map<String, DocParamEntity> params, String checkVal){
        if(checkVal == null){
            if(params.size() == 0){
                return null;
            }
            ConditionResult result = new ConditionResult();
            result.setName(params.keySet().iterator().next());
            result.setDescription("缺少参数");
            result.setWith("接口文档定义未找到该参数");
            return result;
        }
        if(params.isEmpty()){
            ConditionResult result = new ConditionResult();
            result.setDescription("未知参数");
            result.setWith("接口文档定义为无参");
            return result;
        }
        //对比无非三种情况，1-集合  2-对象  3-固定值
        try {
            JSONObject obj = JSONObject.parseObject(checkVal);
            return checkObject(params, obj);
        }catch (JSONException e) {
            try {
                JSONArray array = JSONObject.parseArray(checkVal);
                return checkArray(params, array);
            }catch (JSONException e1) {
                Object o = checkVal;
                return checkConst(params, o);
            }
        }
    }

    private static ConditionResult checkArray(Map<String, DocParamEntity> params,JSONArray array){
        //空定义跳过
        Object ch = params.entrySet().iterator().next().getValue().getChildren();
        if(ch==null || !Collection.class.isAssignableFrom(ch.getClass())){
            return null;
        }
        if(((Collection) ch).size() == 0){
            return null;
        }
        if(!params.containsKey(ProjectContext.nullKey)){
            ConditionResult result = new ConditionResult();
            result.setName(params.keySet().iterator().next());
            result.setDescription("参数类型不匹配");
            result.setWith("接口文档定义参数类型不匹配");
            return result;
        }
        DocParamEntity value = params.entrySet().iterator().next().getValue();
        if(array.isEmpty() && value.getRequired()==0){
            return null;
        }
        DocParamEntity entity = params.entrySet().iterator().next().getValue();
        JavaType javaType = JavaType.getType(entity.getJavaType());
        if(javaType!=JavaType.ArrayObject && javaType!=JavaType.Array){
            ConditionResult result = new ConditionResult();
            result.setName(entity.getName());
            result.setDescription("参数非数组类型");
            result.setWith("接口文档定义非数组类型");
            return result;
        }
        Object obj = array.get(0);
        Map<String, DocParamEntity> children = (Map<String, DocParamEntity>) entity.getChildren();
        return alike(children, JsonUtil.beanToJson(obj));
    }

    private static ConditionResult checkObject(Map<String, DocParamEntity> params,JSONObject object){
        if(params.containsKey(ProjectContext.nullKey)){
            ConditionResult result = new ConditionResult();
            result.setName(params.keySet().iterator().next());
            result.setDescription("参数类型不匹配");
            result.setWith("接口文档定义参数类型不匹配");
            return result;
        }
        Iterator<Map.Entry<String, DocParamEntity>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()){
            Map.Entry<String, DocParamEntity> next = iterator.next();
            String key = next.getKey();
            DocParamEntity value = JsonUtil.jsonToBean(JsonUtil.beanToJson(next.getValue()),DocParamEntity.class);
            Object checkVal = object.get(key);
            if(checkVal == null){
                if(value.getRequired() == 0){
                    continue;
                }
                ConditionResult result = new ConditionResult();
                result.setName(key);
                result.setDescription("缺少参数");
                result.setWith("接口文档定义未找到该参数");
                return result;
            }
            JavaType javaType = JavaType.getType(value.getJavaType());
            if(javaType==JavaType.ArrayObject || javaType==JavaType.Array){
                Map<String,DocParamEntity> entity = new Hashtable<>();
                entity.put(ProjectContext.nullKey, value);
                ConditionResult alike = alike(entity, JsonUtil.beanToJson(checkVal));
                if(alike == null){
                    continue;
                }
                return alike;
            }else if(javaType == JavaType.Object){
                Map<String,DocParamEntity> children = (Map<String, DocParamEntity>) value.getChildren();
                ConditionResult alike = alike(children, JsonUtil.beanToJson(checkVal));
                if(alike == null){
                    continue;
                }
                return alike;
            }
            if(!javaType.alikeClass(checkVal.getClass())){
                ConditionResult result = new ConditionResult();
                result.setName(key);
                result.setDescription("参数类型不匹配");
                result.setWith("接口文档定义参数类型不匹配");
                return result;
            }
            //再校验condition
            String conditionTemplate = value.getConditionTemplate();
            if(StringUtil.isEmpty(conditionTemplate)){
                continue;
            }
            List<String> list = Stream.of(conditionTemplate.split(",")).filter(s -> !StringUtil.isEmpty(s)).collect(Collectors.toList());
            //TODO 逐条校验
        }
        return null;
    }

    private static ConditionResult checkConst(Map<String, DocParamEntity> params,Object obj){
        DocParamEntity entity = params.entrySet().iterator().next().getValue();
        if(!params.containsKey(ProjectContext.nullKey)){
            if(entity.getRequired() == 0){
                return null;
            }
            ConditionResult result = new ConditionResult();
            result.setName(params.keySet().iterator().next());
            result.setDescription("缺少参数");
            result.setWith("接口文档定义未找到该参数");
            return result;
        }
        JavaType javaType = JavaType.getType(entity.getJavaType());
        if(javaType.alikeClass(obj.getClass())){
           return null;
        }
        ConditionResult result = new ConditionResult();
        result.setName(entity.getName());
        result.setDescription("参数类型不匹配");
        result.setWith("接口文档定义参数类型不匹配");
        return result;
    }
}
