package cn.easyutil.easyapi.javadoc.reader;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ClassComment extends JavaSourceComment{

    private String extendsClassName;

    private List<String> implClassNames = new ArrayList<>();

    private String packageName;
    private List<FieldComment> fields = new ArrayList<>();
    private List<MethodComment> methods = new ArrayList<>();


    public void addImplClassNames(String className){
        implClassNames.add(className);
    }

    public void addMethod(MethodComment comment){
        methods.add(comment);
    }

    public void addField(FieldComment comment){
        fields.add(comment);
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public List<FieldComment> getFields() {
        return fields;
    }

    public void setFields(List<FieldComment> fields) {
        this.fields = fields;
    }

    public List<MethodComment> getMethods() {
        return methods;
    }

    public MethodComment getMethod(String methodName){
        Optional<MethodComment> first = this.methods.stream().filter(item -> item.getName().equals(methodName)).findFirst();
        return first.isPresent()?first.get():new MethodComment();
    }

    public void setMethods(List<MethodComment> methods) {
        this.methods = methods;
    }

    public String getExtendsClassName() {
        return extendsClassName;
    }

    public void setExtendsClassName(String extendsClassName) {
        this.extendsClassName = extendsClassName;
    }

    public List<String> getImplClassNames() {
        return implClassNames;
    }

    public void setImplClassNames(List<String> implClassNames) {
        this.implClassNames = implClassNames;
    }
}
