package cn.easyutil.easyapi.interview.session;

import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * 操作当前session
 */
public class CurrentSession {
    private static final String session_user = "session_user";

    public static final String projectId = "projectId";

    public static final String moduleId = "moduleId";

    private static HttpSession getHttpSession(){
        return getRequest().getSession();
    }

    public static HttpServletRequest getRequest(){
        return ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes())).getRequest();
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return servletRequestAttributes.getResponse();
    }

    /**
     * 登陆成功
     * @param user
     */
    public static void loginSuccess(SessionUser user){
        getHttpSession().setAttribute(session_user,user);
    }

    /**
     * 获取当前登陆用户
     * @return
     */
    public static SessionUser getCurrentUser(){
        Object attribute = getHttpSession().getAttribute(session_user);
        if(attribute == null){
            throw new ApidocException("用户未登陆",304);
        }
        return (SessionUser) attribute;
    }

    public static Long getCurrentProjectId(){
        Object header = getRequest().getSession().getAttribute(projectId);
        if(StringUtil.isEmpty(header)){
            return null;
        }
        return Long.parseLong(header.toString());
    }

    public static Long getCurrentModuleId(){
        Object header = getRequest().getSession().getAttribute(moduleId);
        if(StringUtil.isEmpty(header)){
            return null;
        }
        return Long.parseLong(header.toString());
    }
}
