package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.mybatis.service.ModuleService;
import cn.easyutil.easyapi.util.AssertUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@ConditionalOnMissingBean(name = "easyapiModuleController")
@RequestMapping("/easyapi/doc/module")
public class ModuleController {

    private final ModuleService moduleService = new ModuleService();

    @ApidocComment("获取模块列表")
    @PostMapping("/getModules")
    @AccessAuth(code = 1000)
    public List<DBModuleEntity> getModules(){
        Long projectId = CurrentSession.getCurrentProjectId();
        List<Integer> modules = CurrentSession.getCurrentUser().getProjectIds().get(projectId);
        return moduleService.list(
                Wrappers.lambdaQuery(DBModuleEntity.class)
                        .in(DBModuleEntity::getId, modules));
    }

    @ApidocComment("修改模块信息")
    @PostMapping("/updateModules")
    @AccessAuth(code = 1000)
    public void updateModules(@RequestBody DBModuleEntity entity){
        AssertUtil.isNull(entity.getId(), "项目id不能为空");
        if(entity.getDefaultStatus()!=null && entity.getDefaultStatus()==1){
            DBModuleEntity query = new DBModuleEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query = moduleService.getOne(Wrappers.lambdaQuery(query));
            AssertUtil.isTrue(query!=null, "只能有一个默认模块");
        }
        moduleService.updateById(entity);
    }

    @ApidocComment("新增模块信息")
    @PostMapping("/addModules")
    @AccessAuth(code = 1000)
    public void addModules(@RequestBody DBModuleEntity entity){
        if(entity.getDefaultStatus()!=null && entity.getDefaultStatus()==1){
            DBModuleEntity query = new DBModuleEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query = moduleService.getOne(Wrappers.lambdaQuery(query),false);
            AssertUtil.isTrue(query!=null, "只能有一个默认模块");
        }
        moduleService.save(entity);
    }

    @ApidocComment("删除模块信息")
    @PostMapping("/delModules")
    @AccessAuth(code = 1000)
    public void delModules(@RequestBody IdDto dto){
        moduleService.removeById(dto.getId());
    }
}
