package cn.easyutil.easyapi.filter.readReq.model;

import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.readReq.ReadRequestDescription;
import cn.easyutil.easyapi.util.AnnotationUtil;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;

public class RequestDescriptionSwaggerReader implements ReadRequestDescription {
    @Override
    public String description(Type parameterType, String parameterName, ApiExtra extra) {
        if(extra.getParameter() == null){
            return null;
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiImplicitParams", extra.getParameter().getAnnotations());
        if(annotation == null){
            return "";
        }
        Object value = AnnotationUtil.getAnnotationValue(annotation, "value");
        if(value==null || !value.getClass().isArray()){
            return "";
        }
        int length = Array.getLength(value);
        for (int i = 0; i < length; i++) {
            Object o = Array.get(value, i);
            if(o==null || !o.getClass().isAnnotation()){
                continue;
            }
            Object name = AnnotationUtil.getAnnotationValue((Annotation) o, "name");
            if(name!=null && parameterName.equals(name.toString())){
                Object val = AnnotationUtil.getAnnotationValue((Annotation) o, "value");
                if(val != null){
                    return val.toString();
                }
            }
        }
        return null;
    }
}
