package cn.easyutil.easyapi.filter.readInterface.model;

import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceRequestUrl;
import cn.easyutil.easyapi.util.SpringUtil;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Method;
import java.util.Optional;

public class InterfaceRequestUrlCommentReader implements ReadInterfaceRequestUrl {

    @Override
    public String requestUrl(Method method, ApiExtra extra) {
        String baseUrl = Optional.ofNullable(extra.getDbController().getApiPath()).orElse("");
        baseUrl = parseUrl(baseUrl);
        String mapping = Optional.ofNullable(SpringUtil.getRequestPath(method)).orElse("");
        if (!StringUtil.isEmpty(mapping)) {
            mapping =  parseUrl(mapping);
        }
        return baseUrl+mapping;
    }

    /**
     * 完善请求路径
     *
     * @param requestUrl
     * @return
     */
    private String parseUrl(String requestUrl) {
        if (!requestUrl.startsWith("/")) {
            requestUrl = "/" + requestUrl;
        }
        if (requestUrl.endsWith("/")) {
            requestUrl = requestUrl.substring(0, requestUrl.length() - 1);
        }
        return requestUrl;
    }
}
