package cn.easyutil.easyapi.filter.readBean.model;

import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.readBean.ReadBeanParams;
import cn.easyutil.easyapi.logic.creator.FieldParam;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class BeanParamsCommentReader implements ReadBeanParams {
    @Override
    public List<FieldParam> params(Class modelClass, GenericTypeBind bind, ApiExtra extra) {
        Field[] fields = modelClass.getDeclaredFields();
        List<FieldParam> params = new ArrayList<>();
        if(fields.length == 0){
            return params;
        }
        for (Field field : fields) {
            FieldParam param = new FieldParam();
            param.setField(field);
            param.setParamType(field.getGenericType());
            param.setParamName(field.getName());
            params.add(param);
        }
        return params;
    }
}
