package cn.easyutil.easyapi.filter.readBean.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.readBean.ReadBeanIgnore;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;

import java.lang.reflect.Type;

public class BeanIgnoreApiReader implements ReadBeanIgnore {
    @Override
    public Boolean ignore(Type type, GenericTypeBind bind, ApiExtra extra) {
        if(extra.getModelField() == null){
            return false;
        }
        ApidocComment api = extra.getModelField().getDeclaredAnnotation(ApidocComment.class);
        if(api!=null){
            return api.ignore();
        }
        return null;
    }
}
