package cn.easyutil.easyapi.filter.operator;

import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.DefaultReaderEnum;
import cn.easyutil.easyapi.filter.config.ReadResponseConfig;
import cn.easyutil.easyapi.filter.readRes.*;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ReadResponseOperator implements ReadResponseDescription
        , ReadResponseIgnore
        , ReadResponseMockTemplate
        , ReadResponseRequired
        , ReadResponseRetrunTypes
        ,ReadResponseShow {

    private final ReadResponseConfig config;

    public ReadResponseOperator(ReadResponseConfig config) {
        if(config == null){
            config = new ReadResponseConfig();
        }
        this.config = config;
        addDefaults();
    }

    private void addDefaults(){
        config.getReadDescriptions().addAll(DefaultReaderEnum.getDefaults(ReadResponseDescription.class));
        config.getReadIgnore().addAll(DefaultReaderEnum.getDefaults(ReadResponseIgnore.class));
        config.getReadMockTemplate().addAll(DefaultReaderEnum.getDefaults(ReadResponseMockTemplate.class));
        config.getReadRequired().addAll(DefaultReaderEnum.getDefaults(ReadResponseRequired.class));
        config.getReadRetrunTypes().addAll(DefaultReaderEnum.getDefaults(ReadResponseRetrunTypes.class));
        config.getReadShow().addAll(DefaultReaderEnum.getDefaults(ReadResponseShow.class));
    }

    @Override
    public String description(Type type, ApiExtra extra) {
        for (ReadResponseDescription readDescription : config.getReadDescriptions()) {
            String description = readDescription.description(type, extra);
            if(!StringUtil.isEmpty(description)){
                return description;
            }
        }
        return "";
    }

    @Override
    public Boolean ignore(Type type, Class ownerClass, GenericTypeBind bind, ApiExtra extra) {
        for (ReadResponseIgnore readResponseIgnore : config.getReadIgnore()) {
            Boolean ignore = readResponseIgnore.ignore(type, ownerClass, bind, extra);
            if(ignore != null){
                return ignore;
            }
        }
        return false;
    }

    @Override
    public String mockTemplate(Type type, ApiExtra extra) {
        for (ReadResponseMockTemplate readResponseMockTemplate : config.getReadMockTemplate()) {
            String s = readResponseMockTemplate.mockTemplate(type, extra);
            if(!StringUtil.isEmpty(s)){
                return s;
            }
        }
        return "";
    }

    @Override
    public Boolean required(Type type, Class ownerClass, GenericTypeBind bind, ApiExtra extra) {
        for (ReadResponseRequired readResponseRequired : config.getReadRequired()) {
            Boolean required = readResponseRequired.required(type, ownerClass, bind, extra);
            if(required != null){
                return required;
            }
        }
        return true;
    }

    @Override
    public List<MethodParam> returnTypes(Method method, ApiExtra extra) {
        for (ReadResponseRetrunTypes readRetrunType : config.getReadRetrunTypes()) {
            List<MethodParam> methodParams = readRetrunType.returnTypes(method, extra);
            if(methodParams!=null && methodParams.size()>0){
                return methodParams;
            }
        }
        return new ArrayList<>();
    }

    @Override
    public Boolean show(Type type, Class ownerClass, GenericTypeBind bind, ApiExtra extra) {
        for (ReadResponseShow readResponseShow : config.getReadShow()) {
            Boolean show = readResponseShow.show(type, ownerClass, bind, extra);
            if(show != null){
                return show;
            }
        }
        return true;
    }
}
