package cn.easyutil.easyapi.filter.operator;

import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.DefaultReaderEnum;
import cn.easyutil.easyapi.filter.ApiEmptyObj;
import cn.easyutil.easyapi.filter.config.ReadBeanConfig;
import cn.easyutil.easyapi.filter.readBean.*;
import cn.easyutil.easyapi.logic.creator.FieldParam;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ReadBeanOperator implements ReadBeanCondition
        , ReadBeanDescription
        , ReadBeanIgnore
        , ReadBeanJavaType
        , ReadBeanMockTemplate
        ,ReadBeanName,ReadBeanParams
        ,ReadBeanRenewType
        ,ReadBeanRequired
        ,ReadBeanShow
        ,ReadBeanType {

    private final ReadBeanConfig config;

    public ReadBeanOperator(ReadBeanConfig config) {
        if(config == null){
            config = new ReadBeanConfig();
        }
        this.config = config;
        addDefaults();
    }

    private void addDefaults() {
        config.getReadConditions().addAll(DefaultReaderEnum.getDefaults(ReadBeanCondition.class));
        config.getReadDescriptors().addAll(DefaultReaderEnum.getDefaults(ReadBeanDescription.class));
        config.getReadIgnore().addAll(DefaultReaderEnum.getDefaults(ReadBeanIgnore.class));
        config.getReadJavaTypes().addAll(DefaultReaderEnum.getDefaults(ReadBeanJavaType.class));
        config.getReadMockTemplates().addAll(DefaultReaderEnum.getDefaults(ReadBeanMockTemplate.class));
        config.getReadNames().addAll(DefaultReaderEnum.getDefaults(ReadBeanName.class));
        config.getReadParams().addAll(DefaultReaderEnum.getDefaults(ReadBeanParams.class));
        config.getReadRenewTypes().addAll(DefaultReaderEnum.getDefaults(ReadBeanRenewType.class));
        config.getReadRequired().addAll(DefaultReaderEnum.getDefaults(ReadBeanRequired.class));
        config.getReadShow().addAll(DefaultReaderEnum.getDefaults(ReadBeanShow.class));
        config.getReadType().addAll(DefaultReaderEnum.getDefaults(ReadBeanType.class));
    }

    @Override
    public List<String> conditions(Type type, GenericTypeBind bind, ApiExtra extra) {
        for (ReadBeanCondition readCondition : config.getReadConditions()) {
            List<String> conditons = readCondition.conditions(type, bind, extra);
            if(conditons!=null && conditons.size()>0){
                return conditons;
            }
        }
        return new ArrayList<>();
    }

    @Override
    public String description(Type type, GenericTypeBind bind, ApiExtra extra) {
        for (ReadBeanDescription readDescriptor : config.getReadDescriptors()) {
            String description = readDescriptor.description(type, bind, extra);
            if(!StringUtil.isEmpty(description)){
                return description;
            }
        }
        return "";
    }

    @Override
    public Boolean ignore(Type type, GenericTypeBind bind, ApiExtra extra) {
        for (ReadBeanIgnore readBeanIgnore : config.getReadIgnore()) {
            Boolean ignore = readBeanIgnore.ignore(type, bind, extra);
            if(ignore != null){
                return ignore;
            }
        }
        return false;
    }

    @Override
    public JavaType javaType(Type type, GenericTypeBind bind, ApiExtra extra) {
        for (ReadBeanJavaType readJavaType : config.getReadJavaTypes()) {
            JavaType javaType = readJavaType.javaType(type, bind, extra);
            if(javaType != null){
                return javaType;
            }
        }
        return JavaType.Map;
    }

    @Override
    public String mockTemplate(Type type, GenericTypeBind bind, ApiExtra extra) {
        for (ReadBeanMockTemplate readMockTemplate : config.getReadMockTemplates()) {
            String s = readMockTemplate.mockTemplate(type, bind, extra);
            if(!StringUtil.isEmpty(s)){
                return s;
            }
        }
        return "";
    }

    @Override
    public String name(Field field, GenericTypeBind bind, ApiExtra extra) {
        for (ReadBeanName readName : config.getReadNames()) {
            String name = readName.name(field, bind, extra);
            if(!StringUtil.isEmpty(name)){
                return name;
            }
        }
        return field!=null?field.getName():"";
    }

    @Override
    public List<FieldParam> params(Class modelClass, GenericTypeBind bind, ApiExtra extra) {
        for (ReadBeanParams readParam : config.getReadParams()) {
            List<FieldParam> params = readParam.params(modelClass, bind, extra);
            if(params!=null && params.size()>0){
                for (FieldParam param : params) {
                    Field field = param.getField();
                    if(field != null){
                        param.setParamType(type(field,bind,extra));
                        param.setParamName(name(field,bind,extra));
                    }
                }
                return params;
            }
        }
        return new ArrayList<>();
    }

    @Override
    public RenewType renewType(Type type, GenericTypeBind bind, ApiExtra extra) {
        for (ReadBeanRenewType readRenewType : config.getReadRenewTypes()) {
            RenewType renewType = readRenewType.renewType(type, bind, extra);
            if(renewType != null){
                return renewType;
            }
        }
        return RenewType.increment;
    }

    @Override
    public Boolean required(Type type, GenericTypeBind bind, ApiExtra extra) {
        for (ReadBeanRequired readBeanRequired : config.getReadRequired()) {
            Boolean required = readBeanRequired.required(type, bind, extra);
            if(required != null){
                return required;
            }
        }
        return true;
    }

    @Override
    public Boolean show(Type type, GenericTypeBind bind, ApiExtra extra) {
        for (ReadBeanShow readBeanShow : config.getReadShow()) {
            Boolean show = readBeanShow.show(type, bind, extra);
            if(show != null){
                return show;
            }
        }
        return true;
    }

    @Override
    public Type type(Field field, GenericTypeBind bind, ApiExtra extra) {
        for (ReadBeanType readBeanType : config.getReadType()) {
            Type type = readBeanType.type(field, bind, extra);
            if(type != null){
                return type;
            }
        }
        return field!=null?field.getGenericType(): ApiEmptyObj.class;
    }
}
