package cn.easyutil.easyapi.entity.db.unit;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.util.StringUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.apache.commons.codec.Charsets;
import org.apache.ibatis.type.JdbcType;

import java.sql.Blob;

/**
 * 简单测试
 */
@TableName("EASYAPI_SIMPLE_UNIT")
public class DBSimpleUnitEntity extends BaseDbEntity {

    @DDL(value = "USER_ID",ddl = "`USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id'")
    @ApidocComment("用户id")
    private Long userId;

    @DDL(value = "INTERFACE_UNIQUE",ddl = "`INTERFACE_UNIQUE` varchar(50) DEFAULT NULL COMMENT '接口唯一标识'")
    @ApidocComment("接口唯一标识")
    private String interfaceUnique;

    @DDL(value = "TYPE",ddl = "`TYPE` int(1) DEFAULT 0 COMMENT '类型：0-最近执行  1-历史记录'")
    @ApidocComment("类型：0-最近执行  1-历史记录")
    private Integer type;

    @DDL(value = "USE_STYLE_TYPE",ddl = "`USE_STYLE_TYPE` int(1) DEFAULT 0 COMMENT '页面初始展示类型： 0-table 1-json'")
    @ApidocComment("类型：0-最近执行  1-历史记录")
    private Integer useStyleType;

    @DDL(value = "NAME",ddl = "`NAME` varchar(100) DEFAULT NULL COMMENT '测试名称'")
    @ApidocComment("测试名称")
    private String name;

    @TableField(exist = false)
    private String requestUrl;

    @DDL(value = "REQUEST_URL_BYTES",type = Blob.class,ddl = "`REQUEST_URL_BYTES` BLOB DEFAULT NULL COMMENT '请求地址'")
    @ApidocComment("请求地址")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] requestUrlBytes;

    @TableField(exist = false)
    private String jsonParameters;

    @DDL(value = "JSON_PARAMETERS_BYTES",type = Blob.class,ddl = "`JSON_PARAMETERS_BYTES` BLOB DEFAULT NULL COMMENT '请求参数'")
    @ApidocComment("请求参数")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] jsonParametersBytes;

    @TableField(exist = false)
    private String jsonTables;

    @DDL(value = "JSON_TABLES_BYTES",type = Blob.class,ddl = "`JSON_TABLES_BYTES` BLOB DEFAULT NULL COMMENT 'TABLE请求参数'")
    @ApidocComment("table请求参数")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] jsonTablesBytes;

    @TableField(exist = false)
    private String jsonPackages;

    @DDL(value = "JSON_PACKAGES_BYTES",type = Blob.class,ddl = "`JSON_PACKAGES_BYTES` BLOB DEFAULT NULL COMMENT '请求参数包装'")
    @ApidocComment("请求参数包装")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] jsonPackagesBytes;

    @TableField(exist = false)
    private String jsonHeaders;

    @DDL(value = "JSON_HEADERS_BYTES",type = Blob.class,ddl = "`JSON_HEADERS_BYTES` BLOB DEFAULT NULL COMMENT '请求头'")
    @ApidocComment("请求头")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] jsonHeadersBytes;

    @TableField(exist = false)
    private String jsonResponse;

    @DDL(value = "JSON_RESPONSE_BYTES",type = Blob.class,ddl = "`JSON_RESPONSE_BYTES` BLOB DEFAULT NULL COMMENT '接口响应结果'")
    @ApidocComment("接口响应结果")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] jsonResponseBytes;

    @TableField(exist = false)
    private String responseBase64;

    @DDL(value = "RESPONSE_BASE64_BYTES",type = Blob.class,ddl = "`RESPONSE_BASE64_BYTES` BLOB DEFAULT NULL COMMENT '接口响应结果原始数据base64'")
    @ApidocComment("接口响应结果原始数据base64")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] responseBase64Bytes;

    @TableField(exist = false)
    private String jsonResHeaders;

    @DDL(value = "JSON_RES_HEADERS_BYTES",type = Blob.class,ddl = "`JSON_RES_HEADERS_BYTES` BLOB DEFAULT NULL COMMENT '接口响应header'")
    @ApidocComment("接口响应header")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] jsonResHeadersBytes;

    @DDL(value = "ANSWER_TIME",ddl = "`ANSWER_TIME` bigint(20) DEFAULT 0 COMMENT '接口响应时间'")
    @ApidocComment("接口响应时间")
    private Long answerTime;

    @TableField(exist = false)
    private String jsonPreScripts;

    @DDL(value = "JSON_PRE_SCRIPTS_BYTES",type = Blob.class,ddl = "`JSON_PRE_SCRIPTS_BYTES` BLOB DEFAULT NULL COMMENT '前置处理脚本'")
    @ApidocComment("前置处理")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] jsonPreScriptsBytes;

    @TableField(exist = false)
    private String jsonPostScripts;

    @DDL(value = "JSON_POST_SCRIPTS_BYTES",type = Blob.class,ddl = "`JSON_POST_SCRIPTS_BYTES` BLOB DEFAULT NULL COMMENT '后置处理脚本'")
    @ApidocComment("后置处理")
    @TableField(jdbcType = JdbcType.BLOB)
    private byte[] jsonPostScriptsBytes;


    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getInterfaceUnique() {
        return interfaceUnique;
    }

    public void setInterfaceUnique(String interfaceUnique) {
        this.interfaceUnique = interfaceUnique;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getUseStyleType() {
        return useStyleType;
    }

    public void setUseStyleType(Integer useStyleType) {
        this.useStyleType = useStyleType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRequestUrl() {
        return requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
        this.requestUrlBytes = StringUtil.isEmpty(requestUrl)?null:requestUrl.getBytes(Charsets.UTF_8);
    }

    public byte[] getRequestUrlBytes() {
        return requestUrlBytes;
    }

    public void setRequestUrlBytes(byte[] requestUrlBytes) {
        this.requestUrlBytes = requestUrlBytes;
        this.requestUrl = requestUrlBytes==null?null:new String(requestUrlBytes,Charsets.UTF_8);
    }

    public String getJsonParameters() {
        return jsonParameters;
    }

    public void setJsonParameters(String jsonParameters) {
        this.jsonParameters = jsonParameters;
        this.jsonParametersBytes = StringUtil.isEmpty(jsonParameters)?null:jsonParameters.getBytes(Charsets.UTF_8);
    }

    public byte[] getJsonParametersBytes() {
        return jsonParametersBytes;
    }

    public void setJsonParametersBytes(byte[] jsonParametersBytes) {
        this.jsonParametersBytes = jsonParametersBytes;
        this.jsonParameters = jsonParametersBytes==null?null:new String(jsonParametersBytes,Charsets.UTF_8);
    }

    public String getJsonTables() {
        return jsonTables;
    }

    public void setJsonTables(String jsonTables) {
        this.jsonTables = jsonTables;
        this.jsonTablesBytes = StringUtil.isEmpty(jsonTables)?null:jsonTables.getBytes(Charsets.UTF_8);
    }

    public byte[] getJsonTablesBytes() {
        return jsonTablesBytes;
    }

    public void setJsonTablesBytes(byte[] jsonTablesBytes) {
        this.jsonTablesBytes = jsonTablesBytes;
        this.jsonTables = jsonTablesBytes==null?null:new String(jsonTablesBytes,Charsets.UTF_8);
    }

    public String getJsonPackages() {
        return jsonPackages;
    }

    public void setJsonPackages(String jsonPackages) {
        this.jsonPackages = jsonPackages;
        this.jsonPackagesBytes = StringUtil.isEmpty(jsonPackages)?null:jsonPackages.getBytes(Charsets.UTF_8);
    }

    public byte[] getJsonPackagesBytes() {
        return jsonPackagesBytes;
    }

    public void setJsonPackagesBytes(byte[] jsonPackagesBytes) {
        this.jsonPackagesBytes = jsonPackagesBytes;
        this.jsonPackages = jsonPackagesBytes==null?null:new String(jsonPackagesBytes,Charsets.UTF_8);
    }

    public String getJsonHeaders() {
        return jsonHeaders;
    }

    public void setJsonHeaders(String jsonHeaders) {
        this.jsonHeaders = jsonHeaders;
        this.jsonHeadersBytes = StringUtil.isEmpty(jsonHeaders)?null:jsonHeaders.getBytes(Charsets.UTF_8);
    }

    public byte[] getJsonHeadersBytes() {
        return jsonHeadersBytes;
    }

    public void setJsonHeadersBytes(byte[] jsonHeadersBytes) {
        this.jsonHeadersBytes = jsonHeadersBytes;
        this.jsonHeaders = jsonHeadersBytes==null?null:new String(jsonHeadersBytes,Charsets.UTF_8);
    }

    public String getJsonResponse() {
        return jsonResponse;
    }

    public void setJsonResponse(String jsonResponse) {
        this.jsonResponse = jsonResponse;
        this.jsonResponseBytes = StringUtil.isEmpty(jsonResponse)?null:jsonResponse.getBytes(Charsets.UTF_8);
    }

    public byte[] getJsonResponseBytes() {
        return jsonResponseBytes;
    }

    public void setJsonResponseBytes(byte[] jsonResponseBytes) {
        this.jsonResponseBytes = jsonResponseBytes;
        this.jsonResponse = jsonResponseBytes==null?null:new String(jsonResponseBytes,Charsets.UTF_8);
    }

    public String getResponseBase64() {
        return responseBase64;
    }

    public void setResponseBase64(String responseBase64) {
        this.responseBase64 = responseBase64;
        this.responseBase64Bytes = StringUtil.isEmpty(responseBase64)?null:responseBase64.getBytes(Charsets.UTF_8);
    }

    public byte[] getResponseBase64Bytes() {
        return responseBase64Bytes;
    }

    public void setResponseBase64Bytes(byte[] responseBase64Bytes) {
        this.responseBase64Bytes = responseBase64Bytes;
        this.responseBase64 = responseBase64Bytes==null?null:new String(responseBase64Bytes,Charsets.UTF_8);
    }

    public String getJsonResHeaders() {
        return jsonResHeaders;
    }

    public void setJsonResHeaders(String jsonResHeaders) {
        this.jsonResHeaders = jsonResHeaders;
        this.jsonResHeadersBytes = StringUtil.isEmpty(jsonResHeaders)?null:jsonResHeaders.getBytes(Charsets.UTF_8);
    }

    public byte[] getJsonResHeadersBytes() {
        return jsonResHeadersBytes;
    }

    public void setJsonResHeadersBytes(byte[] jsonResHeadersBytes) {
        this.jsonResHeadersBytes = jsonResHeadersBytes;
        this.jsonResHeaders = jsonResHeadersBytes==null?null:new String(jsonResHeadersBytes,Charsets.UTF_8);
    }

    public Long getAnswerTime() {
        return answerTime;
    }

    public void setAnswerTime(Long answerTime) {
        this.answerTime = answerTime;
    }

    public String getJsonPreScripts() {
        return jsonPreScripts;
    }

    public void setJsonPreScripts(String jsonPreScripts) {
        this.jsonPreScripts = jsonPreScripts;
        this.jsonPreScriptsBytes = StringUtil.isEmpty(jsonPreScripts)?null:jsonPreScripts.getBytes(Charsets.UTF_8);
    }

    public byte[] getJsonPreScriptsBytes() {
        return jsonPreScriptsBytes;
    }

    public void setJsonPreScriptsBytes(byte[] jsonPreScriptsBytes) {
        this.jsonPreScriptsBytes = jsonPreScriptsBytes;
        this.jsonPreScripts = jsonPreScriptsBytes==null?null:new String(jsonPreScriptsBytes,Charsets.UTF_8);
    }

    public String getJsonPostScripts() {
        return jsonPostScripts;
    }

    public void setJsonPostScripts(String jsonPostScripts) {
        this.jsonPostScripts = jsonPostScripts;
        this.jsonPostScriptsBytes = StringUtil.isEmpty(jsonPostScripts)?null:jsonPostScripts.getBytes(Charsets.UTF_8);
    }

    public byte[] getJsonPostScriptsBytes() {
        return jsonPostScriptsBytes;
    }

    public void setJsonPostScriptsBytes(byte[] jsonPostScriptsBytes) {
        this.jsonPostScriptsBytes = jsonPostScriptsBytes;
        this.jsonPostScripts = jsonPostScriptsBytes==null?null:new String(jsonPostScriptsBytes,Charsets.UTF_8);
    }
}
