package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import com.baomidou.mybatisplus.annotation.TableName;

/**
 * 项目模块
 */
@TableName("EASYAPI_MODULE")
public class DBModuleEntity extends BaseDbEntity{

    @DDL(value = "NAME",ddl = "`NAME` varchar(100) DEFAULT NULL COMMENT '模块名称'")
    @ApidocComment("模块名称")
    private String name;

    @DDL(value = "DESCRIPTION",ddl = "`DESCRIPTION` varchar(255) DEFAULT 0 COMMENT '模块说明'")
    @ApidocComment("模块说明")
    private String description;

    @DDL(value = "DEFAULT_STATUS",ddl = "`DEFAULT_STATUS` int(1) DEFAULT 0 COMMENT '默认状态：0-默认模块  1-创建模块'")
    @ApidocComment("默认状态：0-默认模块  1-创建模块")
    private Integer defaultStatus;

    @DDL(value = "OUT_PACKGE_STATUS",ddl = "`OUT_PACKGE_STATUS` int(1) DEFAULT 0 COMMENT '本模块是否添加返回外包装 0-不添加  1-添加'")
    @ApidocComment("本模块是否添加返回外包装 0-不添加  1-添加")
    private Integer outPackgeStatus;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getDefaultStatus() {
        return defaultStatus;
    }

    public void setDefaultStatus(Integer defaultStatus) {
        this.defaultStatus = defaultStatus;
    }

    public Integer getOutPackgeStatus() {
        return outPackgeStatus;
    }

    public void setOutPackgeStatus(Integer outPackgeStatus) {
        this.outPackgeStatus = outPackgeStatus;
    }
}
